/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.impl;

import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.state.CombinerValueUpdater;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.state.snapshot.Snapshottable;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Values;

public class CombinerAggStateUpdater
implements StateUpdater<Snapshottable> {
    CombinerAggregator _agg;

    public CombinerAggStateUpdater(CombinerAggregator agg) {
        this._agg = agg;
    }

    @Override
    public void updateState(Snapshottable state, List<TridentTuple> tuples, TridentCollector collector) {
        if (tuples.size() != 1) {
            throw new IllegalArgumentException("Combiner state updater should receive a single tuple. Received: " + tuples.toString());
        }
        Object newVal = state.update(new CombinerValueUpdater(this._agg, tuples.get(0).getValue(0)));
        collector.emit(new Values(newVal));
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
    }

    @Override
    public void cleanup() {
    }
}

