/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.partition;

import java.util.Arrays;
import java.util.List;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.Utils;

public class IndexHashGrouping
implements CustomStreamGrouping {
    int _index;
    List<Integer> _targets;

    public IndexHashGrouping(int index) {
        this._index = index;
    }

    public static int objectToIndex(Object val, int numPartitions) {
        if (val == null) {
            return 0;
        }
        return Utils.toPositive(val.hashCode()) % numPartitions;
    }

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this._targets = targetTasks;
    }

    @Override
    public List<Integer> chooseTasks(int fromTask, List<Object> values) {
        int i = IndexHashGrouping.objectToIndex(values.get(this._index), this._targets.size());
        return Arrays.asList(this._targets.get(i));
    }
}

