/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.FreshCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class PartitionPersistProcessor
implements TridentProcessor {
    StateUpdater _updater;
    State _state;
    String _stateId;
    TridentContext _context;
    Fields _inputFields;
    TridentTupleView.ProjectionFactory _projection;
    FreshCollector _collector;

    public PartitionPersistProcessor(String stateId, Fields inputFields, StateUpdater updater) {
        this._updater = updater;
        this._stateId = stateId;
        this._inputFields = inputFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Partition persist operation can only have one parent");
        }
        this._context = tridentContext;
        this._state = (State)context.getTaskData(this._stateId);
        this._projection = new TridentTupleView.ProjectionFactory(parents.get(0), this._inputFields);
        this._collector = new FreshCollector(tridentContext);
        this._updater.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this._projection));
    }

    @Override
    public void cleanup() {
        this._updater.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        processorContext.state[this._context.getStateIndex()] = new ArrayList();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        ((List)processorContext.state[this._context.getStateIndex()]).add(this._projection.create(tuple));
    }

    @Override
    public void flush() {
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        Object batchId = processorContext.batchId;
        List buffer = (List)processorContext.state[this._context.getStateIndex()];
        if (buffer.size() > 0) {
            Long txid = null;
            if (batchId instanceof TransactionAttempt) {
                txid = ((TransactionAttempt)batchId).getTransactionId();
            }
            this._state.beginCommit(txid);
            this._updater.updateState(this._state, buffer, this._collector);
            this._state.commit(txid);
        }
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._collector.getOutputFactory();
    }
}

