/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IPartitionedTridentSpout;
import org.apache.storm.trident.spout.ISpoutPartition;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.RotatingTransactionalState;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedTridentSpoutExecutor
implements ITridentSpout<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedTridentSpoutExecutor.class);
    IPartitionedTridentSpout<Object, ISpoutPartition, Object> _spout;

    public PartitionedTridentSpoutExecutor(IPartitionedTridentSpout<Object, ISpoutPartition, Object> spout) {
        this._spout = spout;
    }

    public IPartitionedTridentSpout<Object, ISpoutPartition, Object> getPartitionedSpout() {
        return this._spout;
    }

    @Override
    public ITridentSpout.BatchCoordinator<Object> getCoordinator(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Coordinator(conf, context);
    }

    @Override
    public ITridentSpout.Emitter<Object> getEmitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new Emitter(txStateId, conf, context);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._spout.getComponentConfiguration();
    }

    @Override
    public Fields getOutputFields() {
        return this._spout.getOutputFields();
    }

    class Emitter
    implements ITridentSpout.Emitter<Object> {
        Object _savedCoordinatorMeta = null;
        private IPartitionedTridentSpout.Emitter<Object, ISpoutPartition, Object> _emitter;
        private TransactionalState _state;
        private Map<String, EmitterPartitionState> _partitionStates = new HashMap<String, EmitterPartitionState>();
        private int _index;
        private int _numTasks;

        public Emitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
            this._emitter = PartitionedTridentSpoutExecutor.this._spout.getEmitter(conf, context);
            this._state = TransactionalState.newUserState(conf, txStateId);
            this._index = context.getThisTaskIndex();
            this._numTasks = context.getComponentTasks(context.getThisComponentId()).size();
        }

        @Override
        public void emitBatch(final TransactionAttempt tx, Object coordinatorMeta, final TridentCollector collector) {
            LOG.debug("Emitting Batch. [transaction = {}], [coordinatorMeta = {}], [collector = {}]", new Object[]{tx, coordinatorMeta, collector});
            if (this._savedCoordinatorMeta == null || !this._savedCoordinatorMeta.equals(coordinatorMeta)) {
                this._partitionStates.clear();
                List<ISpoutPartition> taskPartitions = this._emitter.getPartitionsForTask(this._index, this._numTasks, this._emitter.getOrderedPartitions(coordinatorMeta));
                for (ISpoutPartition partition : taskPartitions) {
                    this._partitionStates.put(partition.getId(), new EmitterPartitionState(new RotatingTransactionalState(this._state, partition.getId()), partition));
                }
                this._emitter.refreshPartitions(taskPartitions);
                this._savedCoordinatorMeta = coordinatorMeta;
            }
            for (EmitterPartitionState s : this._partitionStates.values()) {
                RotatingTransactionalState state = s.rotatingState;
                final ISpoutPartition partition = s.partition;
                Object meta = state.getStateOrCreate(tx.getTransactionId(), new RotatingTransactionalState.StateInitializer(){

                    @Override
                    public Object init(long txid, Object lastState) {
                        return Emitter.this._emitter.emitPartitionBatchNew(tx, collector, partition, lastState);
                    }
                });
                if (meta == null) continue;
                this._emitter.emitPartitionBatch(tx, collector, partition, meta);
            }
            LOG.debug("Emitted Batch. [tx = {}], [coordinatorMeta = {}], [collector = {}]", new Object[]{tx, coordinatorMeta, collector});
        }

        @Override
        public void success(TransactionAttempt tx) {
            LOG.debug("Success transaction " + tx);
            for (EmitterPartitionState state : this._partitionStates.values()) {
                state.rotatingState.cleanupBefore(tx.getTransactionId());
            }
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this._state.close();
            this._emitter.close();
            LOG.debug("Closed");
        }
    }

    class Coordinator
    implements ITridentSpout.BatchCoordinator<Object> {
        private IPartitionedTridentSpout.Coordinator<Object> _coordinator;

        public Coordinator(Map<String, Object> conf, TopologyContext context) {
            this._coordinator = PartitionedTridentSpoutExecutor.this._spout.getCoordinator(conf, context);
        }

        @Override
        public Object initializeTransaction(long txid, Object prevMetadata, Object currMetadata) {
            LOG.debug("Initialize Transaction. txid = {}, prevMetadata = {}, currMetadata = {}", new Object[]{txid, prevMetadata, currMetadata});
            if (currMetadata != null) {
                return currMetadata;
            }
            return this._coordinator.getPartitionsForBatch();
        }

        @Override
        public void close() {
            LOG.debug("Closing");
            this._coordinator.close();
            LOG.debug("Closed");
        }

        @Override
        public void success(long txid) {
            LOG.debug("Success transaction id " + txid);
        }

        @Override
        public boolean isReady(long txid) {
            boolean ready = this._coordinator.isReady(txid);
            LOG.debug("isReady = {} ", (Object)ready);
            return ready;
        }
    }

    static class EmitterPartitionState {
        public RotatingTransactionalState rotatingState;
        public ISpoutPartition partition;

        public EmitterPartitionState(RotatingTransactionalState s, ISpoutPartition p) {
            this.rotatingState = s;
            this.partition = p;
        }
    }
}

