/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.trident.state.OpaqueValue;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.CachedBatchReadsMap;
import org.apache.storm.trident.state.map.IBackingMap;
import org.apache.storm.trident.state.map.MapState;

public class OpaqueMap<T>
implements MapState<T> {
    CachedBatchReadsMap<OpaqueValue> _backing;
    Long _currTx;

    protected OpaqueMap(IBackingMap<OpaqueValue> backing) {
        this._backing = new CachedBatchReadsMap<OpaqueValue>(backing);
    }

    public static <T> MapState<T> build(IBackingMap<OpaqueValue> backing) {
        return new OpaqueMap<T>(backing);
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        List<CachedBatchReadsMap.RetVal<OpaqueValue>> curr = this._backing.multiGet(keys);
        ArrayList ret = new ArrayList(curr.size());
        for (CachedBatchReadsMap.RetVal<OpaqueValue> retval : curr) {
            OpaqueValue val = (OpaqueValue)retval.val;
            if (val != null) {
                if (retval.cached) {
                    ret.add(val.getCurr());
                    continue;
                }
                ret.add(val.get(this._currTx));
                continue;
            }
            ret.add(null);
        }
        return ret;
    }

    @Override
    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        List<CachedBatchReadsMap.RetVal<OpaqueValue>> curr = this._backing.multiGet(keys);
        ArrayList<OpaqueValue<Object>> newVals = new ArrayList<OpaqueValue<Object>>(curr.size());
        ArrayList ret = new ArrayList();
        for (int i = 0; i < curr.size(); ++i) {
            CachedBatchReadsMap.RetVal<OpaqueValue> retval = curr.get(i);
            OpaqueValue val = (OpaqueValue)retval.val;
            ValueUpdater updater = updaters.get(i);
            Object prev = val == null ? null : (retval.cached ? (Object)val.getCurr() : (Object)val.get(this._currTx));
            Object newVal = updater.update(prev);
            ret.add(newVal);
            OpaqueValue<Object> newOpaqueVal = val == null ? new OpaqueValue<Object>(this._currTx, newVal) : val.update(this._currTx, newVal);
            newVals.add(newOpaqueVal);
        }
        this._backing.multiPut(keys, newVals);
        return ret;
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        ArrayList<ValueUpdater> updaters = new ArrayList<ValueUpdater>(vals.size());
        for (T val : vals) {
            updaters.add(new ReplaceUpdater<T>(val));
        }
        this.multiUpdate(keys, updaters);
    }

    @Override
    public void beginCommit(Long txid) {
        this._currTx = txid;
        this._backing.reset();
    }

    @Override
    public void commit(Long txid) {
        this._currTx = null;
        this._backing.reset();
    }

    static class ReplaceUpdater<T>
    implements ValueUpdater<T> {
        T _t;

        public ReplaceUpdater(T t) {
            this._t = t;
        }

        @Override
        public T update(Object stored) {
            return this._t;
        }
    }
}

