/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.topology.state;

import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatingTransactionalState {
    private static final Logger LOG = LoggerFactory.getLogger(RotatingTransactionalState.class);
    private TransactionalState _state;
    private String _subdir;
    private TreeMap<Long, Object> _curr = new TreeMap();

    public RotatingTransactionalState(TransactionalState state, String subdir) {
        this._state = state;
        this._subdir = subdir;
        state.mkdir(subdir);
        this.sync();
        LOG.debug("Created {}", (Object)this);
    }

    public Object getLastState() {
        if (this._curr.isEmpty()) {
            return null;
        }
        return this._curr.lastEntry().getValue();
    }

    public void overrideState(long txid, Object state) {
        LOG.debug("Overriding state. [txid = {}],  [state = {}]", (Object)txid, state);
        LOG.trace("[{}]", (Object)this);
        this._state.setData(this.txPath(txid), state);
        this._curr.put(txid, state);
        LOG.trace("Overriding state complete.  [{}]", (Object)this);
    }

    public void removeState(long txid) {
        Object state = null;
        if (this._curr.containsKey(txid)) {
            state = this._curr.remove(txid);
            this._state.delete(this.txPath(txid));
        }
        LOG.debug("Removed [state = {}], [txid = {}]", state, (Object)txid);
        LOG.trace("[{}]", (Object)this);
    }

    public Object getState(long txid) {
        Object state = this._curr.get(txid);
        LOG.debug("Getting state. [txid = {}] => [state = {}]", (Object)txid, state);
        LOG.trace("Internal state [{}]", (Object)this);
        return state;
    }

    public Object getState(long txid, StateInitializer init) {
        if (!this._curr.containsKey(txid)) {
            Object data;
            SortedMap<Long, Object> prevMap = this._curr.headMap(txid);
            SortedMap<Long, Object> afterMap = this._curr.tailMap(txid);
            Long prev = null;
            if (!prevMap.isEmpty()) {
                prev = prevMap.lastKey();
            }
            if (afterMap.isEmpty()) {
                Object prevData = prev != null ? this._curr.get(prev) : null;
                data = init.init(txid, prevData);
            } else {
                data = null;
            }
            this._curr.put(txid, data);
            this._state.setData(this.txPath(txid), data);
        }
        Object state = this._curr.get(txid);
        LOG.debug("Getting or initializing state. [txid = {}] => [state = {}]", (Object)txid, state);
        LOG.trace("[{}]", (Object)this);
        return state;
    }

    public Object getPreviousState(long txid) {
        SortedMap<Long, Object> prevMap = this._curr.headMap(txid);
        Object state = prevMap.isEmpty() ? null : prevMap.get(prevMap.lastKey());
        LOG.debug("Getting previous [state = {}], [txid = {}]", state, (Object)txid);
        LOG.trace("[{}]", (Object)this);
        return state;
    }

    public boolean hasCache(long txid) {
        return this._curr.containsKey(txid);
    }

    public Object getStateOrCreate(long txid, StateInitializer init) {
        Object state;
        if (this._curr.containsKey(txid)) {
            state = this._curr.get(txid);
        } else {
            this.getState(txid, init);
            state = null;
        }
        return state;
    }

    public void cleanupBefore(long txid) {
        SortedMap<Long, Object> toDelete = this._curr.headMap(txid);
        for (long tx : new HashSet<Long>(toDelete.keySet())) {
            this._curr.remove(tx);
            try {
                this._state.delete(this.txPath(tx));
            }
            catch (RuntimeException e) {
                if (Utils.exceptionCauseIsInstanceOf(KeeperException.NoNodeException.class, e)) continue;
                throw e;
            }
        }
    }

    private void sync() {
        List<String> txids = this._state.list(this._subdir);
        for (String txid_s : txids) {
            Object data = this._state.getData(this.txPath(txid_s));
            this._curr.put(Long.parseLong(txid_s), data);
        }
    }

    private String txPath(long tx) {
        return this.txPath("" + tx);
    }

    private String txPath(String tx) {
        return this._subdir + "/" + tx;
    }

    public String toString() {
        return "RotatingTransactionalState{_state=" + this._state + ", _subdir='" + this._subdir + '\'' + ", _curr=" + this._curr + '}';
    }

    public static interface StateInitializer {
        public Object init(long var1, Object var3);
    }
}

