/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.tuple;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MessageId {
    static final MessageId unanchoredMsgId = MessageId.makeId(Collections.emptyMap());
    private Map<Long, Long> _anchorsToIds;

    protected MessageId(Map<Long, Long> anchorsToIds) {
        this._anchorsToIds = anchorsToIds;
    }

    public static long generateId(Random rand) {
        return rand.nextLong();
    }

    public static MessageId makeUnanchored() {
        return unanchoredMsgId;
    }

    public static MessageId makeId(Map<Long, Long> anchorsToIds) {
        return new MessageId(anchorsToIds);
    }

    public static MessageId makeRootId(long id, long val) {
        HashMap<Long, Long> anchorsToIds = new HashMap<Long, Long>();
        anchorsToIds.put(id, val);
        return new MessageId(anchorsToIds);
    }

    public static MessageId deserialize(Input in) throws IOException {
        int numAnchors = in.readInt(true);
        HashMap<Long, Long> anchorsToIds = new HashMap<Long, Long>();
        for (int i = 0; i < numAnchors; ++i) {
            anchorsToIds.put(in.readLong(), in.readLong());
        }
        return new MessageId(anchorsToIds);
    }

    public Map<Long, Long> getAnchorsToIds() {
        return this._anchorsToIds;
    }

    public Set<Long> getAnchors() {
        return this._anchorsToIds.keySet();
    }

    public int hashCode() {
        return this._anchorsToIds.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof MessageId && this._anchorsToIds.equals(((MessageId)other)._anchorsToIds);
    }

    public String toString() {
        return this._anchorsToIds.toString();
    }

    public void serialize(Output out) throws IOException {
        out.writeInt(this._anchorsToIds.size(), true);
        for (Map.Entry<Long, Long> anchorToId : this._anchorsToIds.entrySet()) {
            out.writeLong(anchorToId.getKey().longValue());
            out.writeLong(anchorToId.getValue().longValue());
        }
    }
}

