/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.tuple;

import java.util.Collections;
import java.util.List;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.MessageId;
import org.apache.storm.tuple.Tuple;

public class TupleImpl
implements Tuple {
    private final String srcComponent;
    private List<Object> values;
    private int taskId;
    private String streamId;
    private GeneralTopologyContext context;
    private MessageId id;
    private Long _processSampleStartTime;
    private Long _executeSampleStartTime;
    private long _outAckVal = 0L;

    public TupleImpl(Tuple t) {
        this.values = t.getValues();
        this.taskId = t.getSourceTask();
        this.streamId = t.getSourceStreamId();
        this.id = t.getMessageId();
        this.context = t.getContext();
        this.srcComponent = t.getSourceComponent();
        try {
            TupleImpl ti = (TupleImpl)t;
            this._processSampleStartTime = ti._processSampleStartTime;
            this._executeSampleStartTime = ti._executeSampleStartTime;
            this._outAckVal = ti._outAckVal;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public TupleImpl(GeneralTopologyContext context, List<Object> values, String srcComponent, int taskId, String streamId, MessageId id) {
        this.values = context.doSanityCheck() ? Collections.unmodifiableList(values) : values;
        this.taskId = taskId;
        this.streamId = streamId;
        this.id = id;
        this.context = context;
        this.srcComponent = srcComponent;
        if (context.doSanityCheck()) {
            String componentId = context.getComponentId(taskId);
            Fields schema = context.getComponentOutputFields(componentId, streamId);
            if (values.size() != schema.size()) {
                throw new IllegalArgumentException("Tuple created with wrong number of fields. Expected " + schema.size() + " fields but got " + values.size() + " fields");
            }
        }
    }

    public TupleImpl(GeneralTopologyContext context, List<Object> values, String srcComponent, int taskId, String streamId) {
        this(context, values, srcComponent, taskId, streamId, MessageId.makeUnanchored());
    }

    public Long getProcessSampleStartTime() {
        return this._processSampleStartTime;
    }

    public void setProcessSampleStartTime(long ms) {
        this._processSampleStartTime = ms;
    }

    public Long getExecuteSampleStartTime() {
        return this._executeSampleStartTime;
    }

    public void setExecuteSampleStartTime(long ms) {
        this._executeSampleStartTime = ms;
    }

    public void updateAckVal(long val) {
        this._outAckVal ^= val;
    }

    public long getAckVal() {
        return this._outAckVal;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public int fieldIndex(String field) {
        return this.getFields().fieldIndex(field);
    }

    @Override
    public boolean contains(String field) {
        return this.getFields().contains(field);
    }

    @Override
    public Object getValue(int i) {
        return this.values.get(i);
    }

    @Override
    public String getString(int i) {
        return (String)this.values.get(i);
    }

    @Override
    public Integer getInteger(int i) {
        return (Integer)this.values.get(i);
    }

    @Override
    public Long getLong(int i) {
        return (Long)this.values.get(i);
    }

    @Override
    public Boolean getBoolean(int i) {
        return (Boolean)this.values.get(i);
    }

    @Override
    public Short getShort(int i) {
        return (Short)this.values.get(i);
    }

    @Override
    public Byte getByte(int i) {
        return (Byte)this.values.get(i);
    }

    @Override
    public Double getDouble(int i) {
        return (Double)this.values.get(i);
    }

    @Override
    public Float getFloat(int i) {
        return (Float)this.values.get(i);
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.values.get(i);
    }

    @Override
    public Object getValueByField(String field) {
        return this.values.get(this.fieldIndex(field));
    }

    @Override
    public String getStringByField(String field) {
        return (String)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Integer getIntegerByField(String field) {
        return (Integer)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Long getLongByField(String field) {
        return (Long)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Boolean getBooleanByField(String field) {
        return (Boolean)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Short getShortByField(String field) {
        return (Short)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Byte getByteByField(String field) {
        return (Byte)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Double getDoubleByField(String field) {
        return (Double)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Float getFloatByField(String field) {
        return (Float)this.values.get(this.fieldIndex(field));
    }

    @Override
    public byte[] getBinaryByField(String field) {
        return (byte[])this.values.get(this.fieldIndex(field));
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Fields getFields() {
        return this.context.getComponentOutputFields(this.getSourceComponent(), this.getSourceStreamId());
    }

    @Override
    public List<Object> select(Fields selector) {
        return this.getFields().select(selector, this.values);
    }

    @Override
    public GlobalStreamId getSourceGlobalStreamId() {
        return new GlobalStreamId(this.getSourceComponent(), this.streamId);
    }

    @Override
    public String getSourceComponent() {
        return this.srcComponent;
    }

    @Override
    public int getSourceTask() {
        return this.taskId;
    }

    @Override
    public String getSourceStreamId() {
        return this.streamId;
    }

    @Override
    public MessageId getMessageId() {
        return this.id;
    }

    @Override
    public GeneralTopologyContext getContext() {
        return this.context;
    }

    public String toString() {
        return "source: " + this.getSourceComponent() + ":" + this.taskId + ", stream: " + this.streamId + ", id: " + this.id.toString() + ", " + this.values.toString() + " PROC_START_TIME(sampled): " + this._processSampleStartTime + " EXEC_START_TIME(sampled): " + this._executeSampleStartTime;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

