/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RotatingMap<K, V> {
    private static final int DEFAULT_NUM_BUCKETS = 3;
    private final LinkedList<HashMap<K, V>> _buckets;
    private final ExpiredCallback<K, V> _callback;

    public RotatingMap(int numBuckets, ExpiredCallback<K, V> callback) {
        if (numBuckets < 2) {
            throw new IllegalArgumentException("numBuckets must be >= 2");
        }
        this._buckets = new LinkedList();
        for (int i = 0; i < numBuckets; ++i) {
            this._buckets.add(new HashMap());
        }
        this._callback = callback;
    }

    public RotatingMap(ExpiredCallback<K, V> callback) {
        this(3, callback);
    }

    public RotatingMap(int numBuckets) {
        this(numBuckets, null);
    }

    public Map<K, V> rotate() {
        Map dead = this._buckets.removeLast();
        this._buckets.addFirst(new HashMap());
        if (this._callback != null) {
            for (Map.Entry entry : dead.entrySet()) {
                this._callback.expire(entry.getKey(), entry.getValue());
            }
        }
        return dead;
    }

    public boolean containsKey(K key) {
        for (HashMap hashMap : this._buckets) {
            if (!hashMap.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public V get(K key) {
        for (HashMap hashMap : this._buckets) {
            if (!hashMap.containsKey(key)) continue;
            return hashMap.get(key);
        }
        return null;
    }

    public void put(K key, V value) {
        Iterator it = this._buckets.iterator();
        HashMap bucket = (HashMap)it.next();
        bucket.put(key, value);
        while (it.hasNext()) {
            bucket = (HashMap)it.next();
            bucket.remove(key);
        }
    }

    public V remove(K key) {
        for (HashMap hashMap : this._buckets) {
            if (!hashMap.containsKey(key)) continue;
            return hashMap.remove(key);
        }
        return null;
    }

    public int size() {
        int size = 0;
        for (HashMap hashMap : this._buckets) {
            size += hashMap.size();
        }
        return size;
    }

    public static interface ExpiredCallback<K, V> {
        public void expire(K var1, V var2);
    }
}

