/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleVersion
implements Comparable<SimpleVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)[\\.\\-\\_]+(\\d+).*$");
    private final int _major;
    private final int _minor;

    public SimpleVersion(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        int maj = -1;
        int min = -1;
        if (!m.matches()) {
            if (!"Unknown".equals(version)) {
                throw new IllegalArgumentException("Cannot parse '" + version + "'");
            }
        } else {
            maj = Integer.valueOf(m.group(1));
            min = Integer.valueOf(m.group(2));
        }
        this._major = maj;
        this._minor = min;
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int hashCode() {
        return Integer.hashCode(this._major) * 17 & Integer.hashCode(this._minor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleVersion)) {
            return false;
        }
        return this.compareTo((SimpleVersion)o) == 0;
    }

    @Override
    public int compareTo(SimpleVersion o) {
        int ret = Integer.compare(this._major, o._major);
        if (ret == 0) {
            ret = Integer.compare(this._minor, o._minor);
        }
        return ret;
    }

    public String toString() {
        return this._major + "." + this._minor;
    }
}

