/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.utils.Utils;
import org.apache.storm.validation.ConfigValidationAnnotations;
import org.apache.storm.validation.ConfigValidationUtils;
import org.apache.storm.validation.NotConf;
import org.apache.storm.validation.Validated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValidation {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigValidation.class);
    private static final String CONFIG_CLASSES_NAME = "META-INF/services/" + Validated.class.getName();
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int DESIRED_FIELD_ACC = 25;
    private static List<Class<?>> configClasses = null;

    public static void validateField(String fieldName, Map<String, Object> conf) {
        ConfigValidation.validateField(fieldName, conf, ConfigValidation.getConfigClasses());
    }

    public static synchronized List<Class<?>> getConfigClasses() {
        if (configClasses == null) {
            ArrayList ret = new ArrayList();
            HashSet<String> classesToScan = new HashSet<String>();
            classesToScan.add(Config.class.getName());
            for (URL url : Utils.findResources(CONFIG_CLASSES_NAME)) {
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = in.readLine()) != null) {
                            if ((line = line.replaceAll("#.*$", "").trim()).isEmpty()) continue;
                            classesToScan.add(line);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error trying to read " + url, e);
                }
            }
            for (String clazz : classesToScan) {
                try {
                    ret.add(Class.forName(clazz));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            LOG.debug("Will use {} for validation", ret);
            configClasses = ret;
        }
        return configClasses;
    }

    public static void validateField(String fieldName, Map<String, Object> conf, List<Class<?>> configs) {
        Field field = null;
        for (Class<?> clazz : configs) {
            try {
                field = clazz.getField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        if (field == null) {
            throw new RuntimeException("Could not find " + fieldName + " in any of " + configs);
        }
        ConfigValidation.validateField(field, conf);
    }

    public static void validateField(Field field, Map<String, Object> conf) {
        Annotation[] annotations = field.getAnnotations();
        if (annotations.length == 0) {
            LOG.warn("Field {} does not have validator annotation", (Object)field);
        }
        try {
            for (Annotation annotation : annotations) {
                Class<?>[] classes;
                if (annotation.annotationType().equals(Deprecated.class)) {
                    LOG.warn("{} is a deprecated config please see {}.{} for more information.", new Object[]{field.get(null), field.getDeclaringClass(), field.getName()});
                    continue;
                }
                String type = annotation.annotationType().getName();
                Class<?> validatorClass = null;
                for (Class<?> clazz : classes = ConfigValidationAnnotations.class.getDeclaredClasses()) {
                    if (!clazz.getName().equals(type)) continue;
                    validatorClass = clazz;
                    break;
                }
                if (validatorClass == null) continue;
                Object v = validatorClass.cast(annotation);
                String key = (String)field.get(null);
                Class clazz = (Class)validatorClass.getMethod("validatorClass", new Class[0]).invoke(v, new Object[0]);
                Validator o = null;
                Map<String, Object> params = ConfigValidation.getParamsFromAnnotation(validatorClass, v);
                o = ConfigValidation.hasConstructor(clazz, Map.class) ? (Validator)clazz.getConstructor(Map.class).newInstance(params) : (Validator)clazz.newInstance();
                o.validateField(field.getName(), conf.get(key));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void validateTopoConf(Map<String, Object> topoConf) {
        ConfigValidation.validateFields(topoConf, Arrays.asList(Config.class));
    }

    public static void validateFields(Map<String, Object> conf) {
        ConfigValidation.validateFields(conf, ConfigValidation.getConfigClasses());
    }

    public static boolean isFieldAllowed(Field field) {
        return field.getAnnotation(NotConf.class) == null && String.class.equals(field.getType()) && (field.getModifiers() & 0x19) == 25 && !field.isSynthetic();
    }

    public static void validateFields(Map<String, Object> conf, List<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            for (Field field : clazz.getDeclaredFields()) {
                String confKey;
                if (!ConfigValidation.isFieldAllowed(field)) continue;
                Object keyObj = null;
                try {
                    keyObj = field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (!(keyObj instanceof String) || !conf.containsKey(confKey = (String)keyObj)) continue;
                ConfigValidation.validateField(field, conf);
            }
        }
    }

    private static Map<String, Object> getParamsFromAnnotation(Class<?> validatorClass, Object v) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Method method : validatorClass.getDeclaredMethods()) {
            Object value = null;
            try {
                value = method.invoke(v, new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                value = null;
            }
            if (value == null) continue;
            params.put(method.getName(), value);
        }
        return params;
    }

    private static boolean hasConstructor(Class<?> clazz, Class<?> paramClass) {
        Class[] classes = new Class[]{paramClass};
        try {
            clazz.getConstructor(classes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public static class ListOfListOfStringValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) throws IllegalArgumentException {
            if (o == null) {
                return;
            }
            if (o instanceof List) {
                for (Object entry1 : (List)o) {
                    if (entry1 instanceof List) {
                        for (Object entry2 : (List)entry1) {
                            if (entry2 instanceof String) continue;
                            throw new IllegalArgumentException("Field " + name + " must be an Iterable containing only List of List of Strings");
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Field " + name + " must be an Iterable containing only List of List of Strings");
                }
            } else {
                throw new IllegalArgumentException("Field " + name + " must be an Iterable containing only List of List of Strings");
            }
        }
    }

    public static class ImplementsClassValidator
    extends Validator {
        Class<?> classImplements;

        public ImplementsClassValidator(Map<String, Object> params) {
            this.classImplements = (Class)params.get("implementsClass");
        }

        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, String.class, o);
            String className = (String)o;
            try {
                Class<?> objectClass = Class.forName(className);
                if (!this.classImplements.isAssignableFrom(objectClass)) {
                    throw new IllegalArgumentException("Field " + name + " with value " + o + " does not implement " + this.classImplements.getName());
                }
            }
            catch (ClassNotFoundException e) {
                if (className.startsWith("backtype.storm")) {
                    LOG.error("ClassNotFoundException: {}", (Object)className);
                    LOG.warn("Replace backtype.storm with org.apache.storm and try to validate again");
                    LOG.warn("We loosen some constraints here to support topologies of older version running on the current version");
                    this.validateField(name, className.replace("backtype.storm", "org.apache.storm"));
                }
                throw new RuntimeException(e);
            }
        }
    }

    public static class UserResourcePoolEntryValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Map.class, o);
            Map m = (Map)o;
            if (!m.containsKey("cpu")) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: cpu");
            }
            if (!m.containsKey("memory")) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: memory");
            }
            SimpleTypeValidator.validateField(name, Number.class, m.get("cpu"));
            SimpleTypeValidator.validateField(name, Number.class, m.get("memory"));
        }
    }

    public static class PacemakerAuthTypeValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                throw new IllegalArgumentException("Field " + name + " must be set.");
            }
            if (o instanceof String && (((String)o).equals("NONE") || ((String)o).equals("DIGEST") || ((String)o).equals("KERBEROS"))) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be one of \"NONE\", \"DIGEST\", or \"KERBEROS\"");
        }
    }

    public static class MapOfStringToMapOfStringToObjectValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            ConfigValidationUtils.NestableFieldValidator validator = ConfigValidationUtils.mapFv(ConfigValidationUtils.fv(String.class, false), ConfigValidationUtils.mapFv(String.class, Object.class, true), true);
            validator.validateField(name, o);
        }
    }

    public static class EventLoggerRegistryValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Map.class, o);
            if (!((Map)o).containsKey("class")) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: class");
            }
            SimpleTypeValidator.validateField(name, String.class, ((Map)o).get("class"));
            if (((Map)o).containsKey("arguments")) {
                SimpleTypeValidator.validateField(name, Map.class, ((Map)o).get("arguments"));
            }
        }
    }

    public static class MetricReportersValidator
    extends Validator {
        private static final String NIMBUS = "nimbus";
        private static final String SUPERVISOR = "supervisor";
        private static final String WORKER = "worker";
        private static final String CLASS = "class";
        private static final String FILTER = "filter";
        private static final String DAEMONS = "daemons";

        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Map.class, o);
            if (!((Map)o).containsKey(CLASS)) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: class");
            }
            if (!((Map)o).containsKey(DAEMONS)) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: daemons");
            }
            Object list = ((Map)o).get(DAEMONS);
            if (!(list instanceof List)) {
                throw new IllegalArgumentException("Field 'daemons' must be a non-null list.");
            }
            List daemonList = (List)list;
            for (Object string : daemonList) {
                if (string instanceof String && (string.equals(NIMBUS) || string.equals(SUPERVISOR) || string.equals(WORKER))) continue;
                throw new IllegalArgumentException("Field 'daemons' must contain at least one of the following: \"nimbus\", \"supervisor\", or \"worker\"");
            }
            if (((Map)o).containsKey(FILTER)) {
                Map filterMap = (Map)((Map)o).get(FILTER);
                SimpleTypeValidator.validateField(CLASS, String.class, filterMap.get(CLASS));
            }
            SimpleTypeValidator.validateField(name, String.class, ((Map)o).get(CLASS));
        }
    }

    public static class MetricRegistryValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Map.class, o);
            if (!((Map)o).containsKey("class")) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: class");
            }
            if (!((Map)o).containsKey("parallelism.hint")) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: parallelism.hint");
            }
            SimpleTypeValidator.validateField(name, String.class, ((Map)o).get("class"));
            new IntegerValidator().validateField(name, ((Map)o).get("parallelism.hint"));
        }
    }

    public static class ClusterMetricRegistryValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Map.class, o);
            if (!((Map)o).containsKey("class")) {
                throw new IllegalArgumentException("Field " + name + " must have map entry with key: class");
            }
            SimpleTypeValidator.validateField(name, String.class, ((Map)o).get("class"));
        }
    }

    public static class PositiveNumberValidator
    extends Validator {
        private boolean includeZero;

        public PositiveNumberValidator() {
            this.includeZero = false;
        }

        public PositiveNumberValidator(Map<String, Object> params) {
            this.includeZero = (Boolean)params.get("includeZero");
        }

        public static void validateField(String name, boolean includeZero, Object o) {
            if (o == null) {
                return;
            }
            if (o instanceof Number && (includeZero ? ((Number)o).doubleValue() >= 0.0 : ((Number)o).doubleValue() > 0.0)) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be a Positive Number");
        }

        @Override
        public void validateField(String name, Object o) {
            PositiveNumberValidator.validateField(name, this.includeZero, o);
        }
    }

    public static class MapEntryCustomValidator
    extends Validator {
        private Class<?>[] keyValidators;
        private Class<?>[] valueValidators;

        public MapEntryCustomValidator(Map<String, Object> params) {
            this.keyValidators = (Class[])params.get("keyValidatorClasses");
            this.valueValidators = (Class[])params.get("valueValidatorClasses");
        }

        public static void validateField(String name, Class<?>[] keyValidators, Class<?>[] valueValidators, Object o) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Map.class, o);
            for (Map.Entry entry : ((Map)o).entrySet()) {
                for (Class<?> kv : keyValidators) {
                    Object keyValidator = kv.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (keyValidator instanceof Validator) {
                        ((Validator)keyValidator).validateField(name + " Map key", entry.getKey());
                        continue;
                    }
                    LOG.warn("validator: {} cannot be used in MapEntryCustomValidator to validate keys.  Individual entry validators must a instance of Validator class", (Object)kv.getName());
                }
                for (Class<?> vv : valueValidators) {
                    Object valueValidator = vv.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (valueValidator instanceof Validator) {
                        ((Validator)valueValidator).validateField(name + " Map value", entry.getValue());
                        continue;
                    }
                    LOG.warn("validator: {} cannot be used in MapEntryCustomValidator to validate values.  Individual entry validators must a instance of Validator class", (Object)vv.getName());
                }
            }
        }

        @Override
        public void validateField(String name, Object o) {
            try {
                MapEntryCustomValidator.validateField(name, this.keyValidators, this.valueValidators, o);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MapEntryTypeValidator
    extends Validator {
        private Class<?> keyType;
        private Class<?> valueType;

        public MapEntryTypeValidator(Map<String, Object> params) {
            this.keyType = (Class)params.get("keyType");
            this.valueType = (Class)params.get("valueType");
        }

        public static void validateField(String name, Class<?> keyType, Class<?> valueType, Object o) {
            ConfigValidationUtils.NestableFieldValidator validator = ConfigValidationUtils.mapFv(keyType, valueType, false);
            validator.validateField(name, o);
        }

        @Override
        public void validateField(String name, Object o) {
            MapEntryTypeValidator.validateField(name, this.keyType, this.valueType, o);
        }
    }

    public static class ListEntryCustomValidator
    extends Validator {
        private Class<?>[] entryValidators;

        public ListEntryCustomValidator(Map<String, Object> params) {
            this.entryValidators = (Class[])params.get("entryValidatorClasses");
        }

        public static void validateField(String name, Class<?>[] validators, Object o) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Iterable.class, o);
            for (Object entry : (Iterable)o) {
                for (Class<?> validator : validators) {
                    Object v = validator.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (v instanceof Validator) {
                        ((Validator)v).validateField(name + " list entry", entry);
                        continue;
                    }
                    LOG.warn("validator: {} cannot be used in ListEntryCustomValidator.  Individual entry validators must a instance of Validator class", (Object)validator.getName());
                }
            }
        }

        @Override
        public void validateField(String name, Object o) {
            try {
                ListEntryCustomValidator.validateField(name, this.entryValidators, o);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ListEntryTypeValidator
    extends Validator {
        private Class<?> type;

        public ListEntryTypeValidator(Map<String, Object> params) {
            this.type = (Class)params.get("type");
        }

        public static void validateField(String name, Class<?> type, Object o) {
            ConfigValidationUtils.NestableFieldValidator validator = ConfigValidationUtils.listFv(type, false);
            validator.validateField(name, o);
        }

        @Override
        public void validateField(String name, Object o) {
            ListEntryTypeValidator.validateField(name, this.type, o);
        }
    }

    public static class PowerOf2Validator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            long i;
            if (o == null) {
                return;
            }
            if (o instanceof Number && (double)(i = ((Number)o).longValue()) == ((Number)o).doubleValue() && i > 0L && (i & i - 1L) == 0L) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be a power of 2.");
        }
    }

    public static class KryoRegValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            if (o instanceof Iterable) {
                for (Object e : (Iterable)o) {
                    if (e instanceof Map) {
                        for (Map.Entry entry : ((Map)e).entrySet()) {
                            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
                            throw new IllegalArgumentException("Each element of the list " + name + " must be a String or a Map of Strings");
                        }
                        continue;
                    }
                    if (e instanceof String) continue;
                    throw new IllegalArgumentException("Each element of the list " + name + " must be a String or a Map of Strings");
                }
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be an Iterable containing only Strings or Maps of Strings");
        }
    }

    public static class StringOrStringListValidator
    extends Validator {
        private ConfigValidationUtils.FieldValidator fv = ConfigValidationUtils.listFv(String.class, false);

        @Override
        public void validateField(String name, Object o) {
            if (o == null || o instanceof String) {
                return;
            }
            this.fv.validateField(name, o);
        }
    }

    public static class NoDuplicateInListValidator
    extends Validator {
        @Override
        public void validateField(String name, Object field) {
            if (field == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Iterable.class, field);
            HashSet objectSet = new HashSet();
            for (Object o : (Iterable)field) {
                if (objectSet.contains(o)) {
                    throw new IllegalArgumentException(name + " should contain no duplicate elements. Duplicated element: " + o);
                }
                objectSet.add(o);
            }
        }
    }

    public static class ImpersonationAclUserEntryValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            ConfigValidationUtils.NestableFieldValidator validator = ConfigValidationUtils.mapFv(ConfigValidationUtils.fv(String.class, false), ConfigValidationUtils.listFv(String.class, false), false);
            validator.validateField(name, o);
            Map mapObject = (Map)o;
            if (!mapObject.containsKey("hosts")) {
                throw new IllegalArgumentException(name + " should contain Map entry with key: hosts");
            }
            if (!mapObject.containsKey("groups")) {
                throw new IllegalArgumentException(name + " should contain Map entry with key: groups");
            }
        }
    }

    public static class IntegerValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            this.validateInteger(name, o);
        }

        public void validateInteger(String name, Object o) {
            long i;
            if (o == null) {
                return;
            }
            if (o instanceof Number && (double)(i = ((Number)o).longValue()) == ((Number)o).doubleValue() && i <= Integer.MAX_VALUE && i >= Integer.MIN_VALUE) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be an Integer within type range.");
        }
    }

    public static class DoubleValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            SimpleTypeValidator.validateField(name, Double.class, o);
        }
    }

    public static class NumberValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            SimpleTypeValidator.validateField(name, Number.class, o);
        }
    }

    public static class BooleanValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            SimpleTypeValidator.validateField(name, Boolean.class, o);
        }
    }

    public static class StringValidator
    extends Validator {
        private HashSet<String> acceptedValues = null;

        public StringValidator() {
        }

        public StringValidator(Map<String, Object> params) {
            this.acceptedValues = new HashSet<String>(Arrays.asList((String[])params.get("acceptedValues")));
            if (this.acceptedValues.isEmpty() || this.acceptedValues.size() == 1 && this.acceptedValues.contains("")) {
                this.acceptedValues = null;
            }
        }

        @Override
        public void validateField(String name, Object o) {
            SimpleTypeValidator.validateField(name, String.class, o);
            if (this.acceptedValues != null && !this.acceptedValues.contains((String)o)) {
                throw new IllegalArgumentException("Field " + name + " is not an accepted value. Value: " + o + " Accepted values: " + this.acceptedValues);
            }
        }
    }

    public static class DerivedTypeValidator
    extends Validator {
        private Class<?> baseType;

        public DerivedTypeValidator(Map<String, Object> params) {
            this.baseType = (Class)params.get("baseType");
        }

        public static void validateField(String name, Class<?> baseType, Object actualTypeName) {
            if (actualTypeName == null) {
                return;
            }
            try {
                Class<?> actualType = Class.forName(actualTypeName.toString());
                if (baseType.isAssignableFrom(actualType)) {
                    return;
                }
                throw new IllegalArgumentException("Field " + name + " must represent a type that derives from '" + baseType + "'. Specified type = " + actualTypeName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        @Override
        public void validateField(String name, Object actualTypeName) {
            DerivedTypeValidator.validateField(name, this.baseType, actualTypeName);
        }
    }

    public static class SimpleTypeValidator
    extends Validator {
        private Class<?> type;

        public SimpleTypeValidator(Map<String, Object> params) {
            this.type = (Class)params.get("type");
        }

        public static void validateField(String name, Class<?> type, Object o) {
            if (o == null) {
                return;
            }
            if (type.isInstance(o)) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be of type " + type + ". Object: " + o + " actual type: " + o.getClass());
        }

        @Override
        public void validateField(String name, Object o) {
            SimpleTypeValidator.validateField(name, this.type, o);
        }
    }

    public static class NotNullValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                throw new IllegalArgumentException("Field " + name + "cannot be null! Actual value: " + o);
            }
        }
    }

    public static abstract class Validator {
        public Validator(Map<String, Object> params) {
        }

        public Validator() {
        }

        public abstract void validateField(String var1, Object var2);
    }
}

