/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.storm.validation.ConfigValidation;

public class ConfigValidationAnnotations {

    public static class ValidatorParams {
        static final String VALIDATOR_CLASS = "validatorClass";
        static final String TYPE = "type";
        static final String BASE_TYPE = "baseType";
        static final String ENTRY_VALIDATOR_CLASSES = "entryValidatorClasses";
        static final String KEY_VALIDATOR_CLASSES = "keyValidatorClasses";
        static final String VALUE_VALIDATOR_CLASSES = "valueValidatorClasses";
        static final String KEY_TYPE = "keyType";
        static final String VALUE_TYPE = "valueType";
        static final String INCLUDE_ZERO = "includeZero";
        static final String ACCEPTED_VALUES = "acceptedValues";
        static final String IMPLEMENTS_CLASS = "implementsClass";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Password {
        public Class validatorClass() default ConfigValidation.NotNullValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CustomValidator {
        public Class<?> validatorClass();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isPowerOf2 {
        public Class<?> validatorClass() default ConfigValidation.PowerOf2Validator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isKryoReg {
        public Class<?> validatorClass() default ConfigValidation.KryoRegValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isStringOrStringList {
        public Class<?> validatorClass() default ConfigValidation.StringOrStringListValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isImplementationOfClass {
        public Class<?> validatorClass() default ConfigValidation.ImplementsClassValidator.class;

        public Class<?> implementsClass();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isPositiveNumber {
        public Class<?> validatorClass() default ConfigValidation.PositiveNumberValidator.class;

        public boolean includeZero() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isMapEntryCustom {
        public Class<?> validatorClass() default ConfigValidation.MapEntryCustomValidator.class;

        public Class<?>[] keyValidatorClasses();

        public Class<?>[] valueValidatorClasses();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isMapEntryType {
        public Class<?> validatorClass() default ConfigValidation.MapEntryTypeValidator.class;

        public Class<?> keyType();

        public Class<?> valueType();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isListEntryCustom {
        public Class<?> validatorClass() default ConfigValidation.ListEntryCustomValidator.class;

        public Class<?>[] entryValidatorClasses();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isNoDuplicateInList {
        public Class<?> validatorClass() default ConfigValidation.NoDuplicateInListValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NotNull {
        public Class<?> validatorClass() default ConfigValidation.NotNullValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isInteger {
        public Class<?> validatorClass() default ConfigValidation.IntegerValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isBoolean {
        public Class<?> validatorClass() default ConfigValidation.BooleanValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isNumber {
        public Class<?> validatorClass() default ConfigValidation.NumberValidator.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isString {
        public Class<?> validatorClass() default ConfigValidation.StringValidator.class;

        public String[] acceptedValues() default {""};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isListEntryType {
        public Class<?> validatorClass() default ConfigValidation.ListEntryTypeValidator.class;

        public Class<?> type();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isStringList {
        public Class<?> validatorClass() default ConfigValidation.ListEntryTypeValidator.class;

        public Class<?> type() default String.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isDerivedFrom {
        public Class<?> validatorClass() default ConfigValidation.DerivedTypeValidator.class;

        public Class<?> baseType();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface isType {
        public Class<?> validatorClass() default ConfigValidation.SimpleTypeValidator.class;

        public Class<?> type();
    }
}

