/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.clojure;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.RT;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.clojure.ClojureUtil;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.spout.ISpout;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;

public class ClojureSpout
implements IRichSpout {
    Map<String, StreamInfo> _fields;
    List<String> _fnSpec;
    List<String> _confSpec;
    List<Object> _params;
    ISpout _spout;

    public ClojureSpout(List fnSpec, List confSpec, List<Object> params, Map<String, StreamInfo> fields) {
        this._fnSpec = fnSpec;
        this._confSpec = confSpec;
        this._params = params;
        this._fields = fields;
    }

    public void open(final Map<String, Object> conf, final TopologyContext context, SpoutOutputCollector collector) {
        IFn hof = ClojureUtil.loadClojureFn(this._fnSpec.get(0), this._fnSpec.get(1));
        try {
            IFn preparer = (IFn)hof.applyTo(RT.seq(this._params));
            PersistentArrayMap collectorMap = new PersistentArrayMap(new Object[]{Keyword.intern((Symbol)Symbol.create((String)"output-collector")), collector, Keyword.intern((Symbol)Symbol.create((String)"context")), context});
            ArrayList<Object> args = new ArrayList<Object>((Map)collectorMap){
                final /* synthetic */ Map val$collectorMap;
                {
                    this.val$collectorMap = map2;
                    this.add(conf);
                    this.add(context);
                    this.add(this.val$collectorMap);
                }
            };
            this._spout = (ISpout)preparer.applyTo(RT.seq((Object)args));
            try {
                this._spout.open(conf, context, collector);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this._spout.close();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void nextTuple() {
        try {
            this._spout.nextTuple();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void ack(Object msgId) {
        try {
            this._spout.ack(msgId);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void fail(Object msgId) {
        try {
            this._spout.fail(msgId);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (String stream : this._fields.keySet()) {
            StreamInfo info2 = this._fields.get(stream);
            declarer.declareStream(stream, info2.is_direct(), new Fields(info2.get_output_fields()));
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        IFn hof = ClojureUtil.loadClojureFn(this._confSpec.get(0), this._confSpec.get(1));
        try {
            return (Map)hof.applyTo(RT.seq(this._params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void activate() {
        try {
            this._spout.activate();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void deactivate() {
        try {
            this._spout.deactivate();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }
}

