/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.storm.elasticsearch.EsLookupResultOutput;
import org.apache.storm.elasticsearch.response.LookupResponse;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.elasticsearch.client.Response;

public class DefaultEsLookupResultOutput
implements EsLookupResultOutput {
    private static final long serialVersionUID = 2932278450655703239L;
    private ObjectMapper objectMapper;

    public DefaultEsLookupResultOutput(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Collection<Values> toValues(Response response) {
        LookupResponse lookupResponse;
        try {
            lookupResponse = (LookupResponse)this.objectMapper.readValue(response.getEntity().getContent(), LookupResponse.class);
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new IllegalArgumentException("Response " + response + " is invalid", e);
        }
        return Collections.singleton(new Values(new Object[]{lookupResponse.getIndex(), lookupResponse.getType(), lookupResponse.getId(), lookupResponse.getSource()}));
    }

    @Override
    public Fields fields() {
        return new Fields(new String[]{"index", "type", "id", "source"});
    }
}

