/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.bolt;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.storm.elasticsearch.DefaultEsLookupResultOutput;
import org.apache.storm.elasticsearch.EsLookupResultOutput;
import org.apache.storm.elasticsearch.bolt.AbstractEsBolt;
import org.apache.storm.elasticsearch.common.DefaultEsTupleMapper;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.EsTupleMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.elasticsearch.client.Response;

public class EsLookupBolt
extends AbstractEsBolt {
    private final EsTupleMapper tupleMapper;
    private final EsLookupResultOutput output;

    public EsLookupBolt(EsConfig esConfig) {
        this(esConfig, new DefaultEsTupleMapper(), new DefaultEsLookupResultOutput(objectMapper));
    }

    public EsLookupBolt(EsConfig esConfig, EsTupleMapper tupleMapper, EsLookupResultOutput output) {
        super(esConfig);
        this.tupleMapper = Objects.requireNonNull(tupleMapper);
        this.output = Objects.requireNonNull(output);
    }

    public void process(Tuple tuple) {
        try {
            Collection<Values> values = this.lookupValuesInEs(tuple);
            this.tryEmitAndAck(values, tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    private Collection<Values> lookupValuesInEs(Tuple tuple) throws IOException {
        String index = this.tupleMapper.getIndex((ITuple)tuple);
        String type = this.tupleMapper.getType((ITuple)tuple);
        String id = this.tupleMapper.getId((ITuple)tuple);
        Map<String, String> params = this.tupleMapper.getParams((ITuple)tuple, new HashMap<String, String>());
        Response response = client.performRequest("get", EsLookupBolt.getEndpoint(index, type, id), params, new Header[0]);
        return this.output.toValues(response);
    }

    private void tryEmitAndAck(Collection<Values> values, Tuple tuple) {
        for (Values value : values) {
            this.collector.emit(tuple, (List)value);
        }
        this.collector.ack(tuple);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        outputFieldsDeclarer.declare(this.output.fields());
    }
}

