/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.common;

import java.io.Serializable;
import org.apache.http.HttpHost;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public final class StormElasticSearchClient
implements Serializable {
    private final EsConfig esConfig;

    public StormElasticSearchClient(EsConfig esConfig) {
        this.esConfig = esConfig;
    }

    public RestClient construct() {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.esConfig.getHttpHosts());
        if (this.esConfig.getMaxRetryTimeoutMillis() != null) {
            builder.setMaxRetryTimeoutMillis(this.esConfig.getMaxRetryTimeoutMillis().intValue());
        }
        if (this.esConfig.getDefaultHeaders() != null) {
            builder.setDefaultHeaders(this.esConfig.getDefaultHeaders());
        }
        if (this.esConfig.getFailureListener() != null) {
            builder.setFailureListener(this.esConfig.getFailureListener());
        }
        if (this.esConfig.getHttpClientConfigCallback() != null) {
            builder.setHttpClientConfigCallback(this.esConfig.getHttpClientConfigCallback());
        }
        if (this.esConfig.getRequestConfigCallback() != null) {
            builder.setRequestConfigCallback(this.esConfig.getRequestConfigCallback());
        }
        if (this.esConfig.getPathPrefix() != null) {
            builder.setPathPrefix(this.esConfig.getPathPrefix());
        }
        return builder.build();
    }
}

