/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.trident;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.EsTupleMapper;
import org.apache.storm.elasticsearch.common.StormElasticSearchClient;
import org.apache.storm.elasticsearch.doc.Index;
import org.apache.storm.elasticsearch.doc.IndexDoc;
import org.apache.storm.elasticsearch.doc.SourceDoc;
import org.apache.storm.elasticsearch.response.BulkIndexResponse;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EsState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(EsState.class);
    private static RestClient client;
    private EsConfig esConfig;
    private final ObjectMapper objectMapper;
    private EsTupleMapper tupleMapper;

    public EsState(EsConfig esConfig, EsTupleMapper tupleMapper) {
        this.esConfig = esConfig;
        this.objectMapper = new ObjectMapper();
        this.tupleMapper = tupleMapper;
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        try {
            Class<EsState> clazz = EsState.class;
            synchronized (EsState.class) {
                if (client == null) {
                    client = new StormElasticSearchClient(this.esConfig).construct();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOG.warn("unable to initialize EsState ", (Throwable)e);
        }
        {
            return;
        }
    }

    private String buildRequest(List<TridentTuple> tuples) throws JsonProcessingException {
        StringBuilder bulkRequest = new StringBuilder();
        for (TridentTuple tuple : tuples) {
            String source = this.tupleMapper.getSource((ITuple)tuple);
            String index = this.tupleMapper.getIndex((ITuple)tuple);
            String type = this.tupleMapper.getType((ITuple)tuple);
            String id = this.tupleMapper.getId((ITuple)tuple);
            IndexDoc indexDoc = new IndexDoc(new Index(index, type, id));
            SourceDoc sourceDoc = new SourceDoc(source);
            bulkRequest.append(this.objectMapper.writeValueAsString((Object)indexDoc)).append('\n');
            bulkRequest.append(this.objectMapper.writeValueAsString((Object)sourceDoc)).append('\n');
        }
        return bulkRequest.toString();
    }

    public void updateState(List<TridentTuple> tuples) {
        try {
            String bulkRequest = this.buildRequest(tuples);
            Response response = client.performRequest("post", "_bulk", new HashMap(), (HttpEntity)new StringEntity(bulkRequest.toString()), new Header[0]);
            BulkIndexResponse bulkResponse = (BulkIndexResponse)this.objectMapper.readValue(response.getEntity().getContent(), BulkIndexResponse.class);
            if (bulkResponse.hasErrors()) {
                LOG.warn("failed processing bulk index requests: " + bulkResponse.getFirstError() + ": " + bulkResponse.getFirstResult());
                throw new FailedException();
            }
        }
        catch (IOException e) {
            LOG.warn("failed processing bulk index requests: " + e.toString());
            throw new FailedException((Throwable)e);
        }
    }
}

