/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common.security;

import backtype.storm.security.INimbusCredentialPlugin;
import backtype.storm.security.auth.IAutoCredentials;
import backtype.storm.security.auth.ICredentialsRenewer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHDFS
implements IAutoCredentials,
ICredentialsRenewer,
INimbusCredentialPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHDFS.class);
    public static final String HDFS_CREDENTIALS = "HDFS_CREDENTIALS";
    public static final String TOPOLOGY_HDFS_URI = "topology.hdfs.uri";
    private String hdfsKeyTab;
    private String hdfsPrincipal;

    public void prepare(Map conf) {
        if (conf.containsKey("hdfs.keytab.file") && conf.containsKey("hdfs.kerberos.principal")) {
            this.hdfsKeyTab = (String)conf.get("hdfs.keytab.file");
            this.hdfsPrincipal = (String)conf.get("hdfs.kerberos.principal");
        }
    }

    public void shutdown() {
    }

    public void populateCredentials(Map<String, String> credentials, Map conf) {
        try {
            credentials.put(this.getCredentialKey(), DatatypeConverter.printBase64Binary((byte[])this.getHadoopCredentials(conf)));
            LOG.info("HDFS tokens added to credentials map.");
        }
        catch (Exception e) {
            LOG.error("Could not populate HDFS credentials.", (Throwable)e);
        }
    }

    public void populateCredentials(Map<String, String> credentials) {
        credentials.put(HDFS_CREDENTIALS, DatatypeConverter.printBase64Binary((byte[])"dummy place holder".getBytes()));
    }

    protected Credentials getCredentials(Map<String, String> credentials) {
        Credentials credential = null;
        if (credentials != null && credentials.containsKey(this.getCredentialKey())) {
            try {
                byte[] credBytes = DatatypeConverter.parseBase64Binary((String)credentials.get(this.getCredentialKey()));
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(credBytes));
                credential = new Credentials();
                credential.readFields((DataInput)in);
            }
            catch (Exception e) {
                LOG.error("Could not obtain credentials from credentials map.", (Throwable)e);
            }
        }
        return credential;
    }

    public void updateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    public void populateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    private void addCredentialToSubject(Subject subject, Map<String, String> credentials) {
        try {
            Credentials credential = this.getCredentials(credentials);
            if (credential != null) {
                subject.getPrivateCredentials().add(credential);
                LOG.info("HDFS Credentials added to the subject.");
            } else {
                LOG.info("No credential found in credentials");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize and get UserGroupInformation.", (Throwable)e);
        }
    }

    public void addTokensToUGI(Subject subject) {
        Set<Credentials> privateCredentials;
        if (subject != null && (privateCredentials = subject.getPrivateCredentials(Credentials.class)) != null) {
            for (Credentials cred : privateCredentials) {
                Collection allTokens = cred.getAllTokens();
                if (allTokens == null) continue;
                for (Token token : allTokens) {
                    try {
                        UserGroupInformation.getCurrentUser().addToken(token);
                        LOG.info("Added delegation tokens to UGI.");
                    }
                    catch (IOException e) {
                        LOG.error("Exception while trying to add tokens to ugi", (Throwable)e);
                    }
                }
            }
        }
    }

    public void renew(Map<String, String> credentials, Map topologyConf) {
        try {
            Credentials credential = this.getCredentials(credentials);
            if (credential != null) {
                Configuration configuration = new Configuration();
                Collection tokens = credential.getAllTokens();
                if (tokens != null && !tokens.isEmpty()) {
                    for (Token token : tokens) {
                        this.login(configuration);
                        long expiration = token.renew(configuration);
                        LOG.info("HDFS delegation token renewed, new expiration time {}", (Object)expiration);
                    }
                } else {
                    LOG.debug("No tokens found for credentials, skipping renewal.");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("could not renew the credentials, one of the possible reason is tokens are beyond renewal period so attempting to get new tokens.", (Throwable)e);
            this.populateCredentials(credentials, topologyConf);
        }
    }

    protected byte[] getHadoopCredentials(Map conf) {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                final Configuration configuration = new Configuration();
                this.login(configuration);
                final String topologySubmitterUser = (String)conf.get("topology.submitter.principal");
                final URI nameNodeURI = conf.containsKey(TOPOLOGY_HDFS_URI) ? new URI(conf.get(TOPOLOGY_HDFS_URI).toString()) : FileSystem.getDefaultUri((Configuration)configuration);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                final UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)topologySubmitterUser, (UserGroupInformation)ugi);
                Credentials creds = (Credentials)proxyUser.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            FileSystem fileSystem = FileSystem.get((URI)nameNodeURI, (Configuration)configuration);
                            Credentials credential = proxyUser.getCredentials();
                            fileSystem.addDelegationTokens(AutoHDFS.this.hdfsPrincipal, credential);
                            LOG.info("Delegation tokens acquired for user {}", (Object)topologySubmitterUser);
                            return credential;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bao);
                creds.write((DataOutput)out);
                out.flush();
                out.close();
                return bao.toByteArray();
            }
            throw new RuntimeException("Security is not enabled for HDFS");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    private void login(Configuration configuration) throws IOException {
        configuration.set("hdfs.keytab.file", this.hdfsKeyTab);
        configuration.set("hdfs.kerberos.principal", this.hdfsPrincipal);
        SecurityUtil.login((Configuration)configuration, (String)"hdfs.keytab.file", (String)"hdfs.kerberos.principal");
        LOG.info("Logged into hdfs with principal {}", (Object)this.hdfsPrincipal);
    }

    protected String getCredentialKey() {
        return HDFS_CREDENTIALS;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("topology.submitter.principal", args[0]);
        conf.put("hdfs.kerberos.principal", args[1]);
        conf.put("hdfs.keytab.file", args[2]);
        Configuration configuration = new Configuration();
        AutoHDFS autoHDFS = new AutoHDFS();
        autoHDFS.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHDFS.populateCredentials(creds, conf);
        LOG.info("Got HDFS credentials", (Object)autoHDFS.getCredentials(creds));
        Subject s = new Subject();
        autoHDFS.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
        autoHDFS.renew(creds, conf);
        LOG.info("renewed credentials", (Object)autoHDFS.getCredentials(creds));
    }
}

