/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common.security;

import backtype.storm.security.auth.kerberos.AutoTGT;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.storm.hdfs.common.security.AutoHDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSecurityUtil {
    public static final String STORM_KEYTAB_FILE_KEY = "hdfs.keytab.file";
    public static final String STORM_USER_NAME_KEY = "hdfs.kerberos.principal";
    private static final Logger LOG = LoggerFactory.getLogger(HdfsSecurityUtil.class);

    public static void login(Map conf, Configuration hdfsConfig) throws IOException {
        if ((conf.get("topology.auto-credentials") == null || !((List)conf.get("topology.auto-credentials")).contains(AutoHDFS.class.getName()) && !((List)conf.get("topology.auto-credentials")).contains(AutoTGT.class.getName())) && UserGroupInformation.isSecurityEnabled()) {
            String userName;
            LOG.info("Logging in using keytab as AutoHDFS is not specified for topology.auto-credentials");
            String keytab = (String)conf.get(STORM_KEYTAB_FILE_KEY);
            if (keytab != null) {
                hdfsConfig.set(STORM_KEYTAB_FILE_KEY, keytab);
            }
            if ((userName = (String)conf.get(STORM_USER_NAME_KEY)) != null) {
                hdfsConfig.set(STORM_USER_NAME_KEY, userName);
            }
            SecurityUtil.login((Configuration)hdfsConfig, (String)STORM_KEYTAB_FILE_KEY, (String)STORM_USER_NAME_KEY);
        }
    }
}

