/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident.format;

import java.util.Map;
import org.apache.storm.hdfs.trident.format.FileNameFormat;

public class DefaultFileNameFormat
implements FileNameFormat {
    private int partitionIndex;
    private String path = "/storm";
    private String prefix = "";
    private String extension = ".txt";

    public DefaultFileNameFormat withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public DefaultFileNameFormat withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public DefaultFileNameFormat withPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public void prepare(Map conf, int partitionIndex, int numPartitions) {
        this.partitionIndex = partitionIndex;
    }

    @Override
    public String getName(long rotation, long timeStamp) {
        return this.prefix + "-" + this.partitionIndex + "-" + rotation + "-" + timeStamp + this.extension;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

