/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident.format;

import backtype.storm.tuple.Fields;
import org.apache.storm.hdfs.trident.format.RecordFormat;
import storm.trident.tuple.TridentTuple;

public class DelimitedRecordFormat
implements RecordFormat {
    public static final String DEFAULT_FIELD_DELIMITER = ",";
    public static final String DEFAULT_RECORD_DELIMITER = "\n";
    private String fieldDelimiter = ",";
    private String recordDelimiter = "\n";
    private Fields fields = null;

    public DelimitedRecordFormat withFields(Fields fields) {
        this.fields = fields;
        return this;
    }

    public DelimitedRecordFormat withFieldDelimiter(String delimiter) {
        this.fieldDelimiter = delimiter;
        return this;
    }

    public DelimitedRecordFormat withRecordDelimiter(String delimiter) {
        this.recordDelimiter = delimiter;
        return this;
    }

    @Override
    public byte[] format(TridentTuple tuple) {
        StringBuilder sb = new StringBuilder();
        int size = this.fields.size();
        for (int i = 0; i < size; ++i) {
            sb.append(tuple.getValueByField(this.fields.get(i)));
            if (i == size - 1) continue;
            sb.append(this.fieldDelimiter);
        }
        sb.append(this.recordDelimiter);
        return sb.toString().getBytes();
    }
}

