/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.trident;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import storm.kafka.Broker;
import storm.kafka.Partition;

public class GlobalPartitionInformation
implements Iterable<Partition>,
Serializable {
    private Map<Integer, Broker> partitionMap = new TreeMap<Integer, Broker>();

    public void addPartition(int partitionId, Broker broker) {
        this.partitionMap.put(partitionId, broker);
    }

    public String toString() {
        return "GlobalPartitionInformation{partitionMap=" + this.partitionMap + '}';
    }

    public Broker getBrokerFor(Integer partitionId) {
        return this.partitionMap.get(partitionId);
    }

    public List<Partition> getOrderedPartitions() {
        LinkedList<Partition> partitions = new LinkedList<Partition>();
        for (Map.Entry<Integer, Broker> partition : this.partitionMap.entrySet()) {
            partitions.add(new Partition(partition.getValue(), partition.getKey()));
        }
        return partitions;
    }

    @Override
    public Iterator<Partition> iterator() {
        final Iterator<Map.Entry<Integer, Broker>> iterator = this.partitionMap.entrySet().iterator();
        return new Iterator<Partition>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Partition next() {
                Map.Entry next = (Map.Entry)iterator.next();
                return new Partition((Broker)next.getValue(), (Integer)next.getKey());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partitionMap});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalPartitionInformation other = (GlobalPartitionInformation)obj;
        return Objects.equal(this.partitionMap, other.partitionMap);
    }
}

