/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.trident;

import backtype.storm.task.OutputCollector;
import backtype.storm.topology.FailedException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.trident.mapper.TridentTupleToKafkaMapper;
import storm.kafka.trident.selector.KafkaTopicSelector;
import storm.trident.operation.TridentCollector;
import storm.trident.state.State;
import storm.trident.tuple.TridentTuple;

public class TridentKafkaState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(TridentKafkaState.class);
    public static final String KAFKA_BROKER_PROPERTIES = "kafka.broker.properties";
    private Producer producer;
    private OutputCollector collector;
    private TridentTupleToKafkaMapper mapper;
    private KafkaTopicSelector topicSelector;

    public TridentKafkaState withTridentTupleToKafkaMapper(TridentTupleToKafkaMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public TridentKafkaState withKafkaTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public void beginCommit(Long txid) {
        LOG.debug("beginCommit is Noop.");
    }

    public void commit(Long txid) {
        LOG.debug("commit is Noop.");
    }

    public void prepare(Map stormConf) {
        Validate.notNull((Object)this.mapper, (String)"mapper can not be null");
        Validate.notNull((Object)this.topicSelector, (String)"topicSelector can not be null");
        Map configMap = (Map)stormConf.get(KAFKA_BROKER_PROPERTIES);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)configMap);
        ProducerConfig config = new ProducerConfig(properties);
        this.producer = new Producer(config);
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        String topic = null;
        for (TridentTuple tuple : tuples) {
            try {
                topic = this.topicSelector.getTopic(tuple);
                if (topic != null) {
                    this.producer.send(new KeyedMessage(topic, this.mapper.getKeyFromTuple(tuple), this.mapper.getMessageFromTuple(tuple)));
                    continue;
                }
                LOG.warn("skipping key = " + this.mapper.getKeyFromTuple(tuple) + ", topic selector returned null.");
            }
            catch (Exception ex) {
                String errorMsg = "Could not send message with key = " + this.mapper.getKeyFromTuple(tuple) + " to topic = " + topic;
                LOG.warn(errorMsg, (Throwable)ex);
                throw new FailedException(errorMsg, (Throwable)ex);
            }
        }
    }
}

