/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.trident;

import java.net.SocketTimeoutException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.DynamicBrokersReader;
import storm.kafka.ZkHosts;
import storm.kafka.trident.GlobalPartitionInformation;
import storm.kafka.trident.IBrokerReader;

public class ZkBrokerReader
implements IBrokerReader {
    public static final Logger LOG = LoggerFactory.getLogger(ZkBrokerReader.class);
    GlobalPartitionInformation cachedBrokers;
    DynamicBrokersReader reader;
    long lastRefreshTimeMs;
    long refreshMillis;

    public ZkBrokerReader(Map conf, String topic, ZkHosts hosts) {
        try {
            this.reader = new DynamicBrokersReader(conf, hosts.brokerZkStr, hosts.brokerZkPath, topic);
            this.cachedBrokers = this.reader.getBrokerInfo();
            this.lastRefreshTimeMs = System.currentTimeMillis();
            this.refreshMillis = (long)hosts.refreshFreqSecs * 1000L;
        }
        catch (SocketTimeoutException e) {
            LOG.warn("Failed to update brokers", (Throwable)e);
        }
    }

    @Override
    public GlobalPartitionInformation getCurrentBrokers() {
        long currTime = System.currentTimeMillis();
        if (currTime > this.lastRefreshTimeMs + this.refreshMillis) {
            try {
                LOG.info("brokers need refreshing because " + this.refreshMillis + "ms have expired");
                this.cachedBrokers = this.reader.getBrokerInfo();
                this.lastRefreshTimeMs = currTime;
            }
            catch (SocketTimeoutException e) {
                LOG.warn("Failed to update brokers", (Throwable)e);
            }
        }
        return this.cachedBrokers;
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

