/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import backtype.storm.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.KeeperException;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.Broker;
import storm.kafka.trident.GlobalPartitionInformation;

public class DynamicBrokersReader {
    public static final Logger LOG = LoggerFactory.getLogger(DynamicBrokersReader.class);
    private CuratorFramework _curator;
    private String _zkPath;
    private String _topic;

    public DynamicBrokersReader(Map conf, String zkStr, String zkPath, String topic) {
        this._zkPath = zkPath;
        this._topic = topic;
        try {
            this._curator = CuratorFrameworkFactory.newClient((String)zkStr, (int)Utils.getInt(conf.get("storm.zookeeper.session.timeout")), (int)15000, (RetryPolicy)new RetryNTimes(Utils.getInt(conf.get("storm.zookeeper.retry.times")).intValue(), Utils.getInt(conf.get("storm.zookeeper.retry.interval")).intValue()));
            this._curator.start();
        }
        catch (Exception ex) {
            LOG.error("Couldn't connect to zookeeper", (Throwable)ex);
        }
    }

    public GlobalPartitionInformation getBrokerInfo() throws SocketTimeoutException {
        GlobalPartitionInformation globalPartitionInformation = new GlobalPartitionInformation();
        try {
            int numPartitionsForTopic = this.getNumPartitions();
            String brokerInfoPath = this.brokerPath();
            for (int partition = 0; partition < numPartitionsForTopic; ++partition) {
                int leader = this.getLeaderFor(partition);
                String path = brokerInfoPath + "/" + leader;
                try {
                    byte[] brokerData = (byte[])this._curator.getData().forPath(path);
                    Broker hp = this.getBrokerHost(brokerData);
                    globalPartitionInformation.addPartition(partition, hp);
                    continue;
                }
                catch (KeeperException.NoNodeException e) {
                    LOG.error("Node {} does not exist ", (Object)path);
                }
            }
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info("Read partition info from zookeeper: " + globalPartitionInformation);
        return globalPartitionInformation;
    }

    private int getNumPartitions() {
        try {
            String topicBrokersPath = this.partitionPath();
            List children = (List)this._curator.getChildren().forPath(topicBrokersPath);
            return children.size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String partitionPath() {
        return this._zkPath + "/topics/" + this._topic + "/partitions";
    }

    public String brokerPath() {
        return this._zkPath + "/ids";
    }

    private int getLeaderFor(long partition) {
        try {
            String topicBrokersPath = this.partitionPath();
            byte[] hostPortData = (byte[])this._curator.getData().forPath(topicBrokersPath + "/" + partition + "/state");
            Map value = (Map)JSONValue.parse((String)new String(hostPortData, "UTF-8"));
            Integer leader = ((Number)value.get("leader")).intValue();
            return leader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this._curator.close();
    }

    private Broker getBrokerHost(byte[] contents) {
        try {
            Map value = (Map)JSONValue.parse((String)new String(contents, "UTF-8"));
            String host = (String)value.get("host");
            Integer port = ((Long)value.get("port")).intValue();
            return new Broker(host, port);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

