/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.KafkaSpoutStreams;
import org.apache.storm.kafka.spout.KafkaSpoutTuplesBuilder;

public class KafkaSpoutConfig<K, V>
implements Serializable {
    public static final long DEFAULT_POLL_TIMEOUT_MS = 2000L;
    public static final long DEFAULT_OFFSET_COMMIT_PERIOD_MS = 15000L;
    public static final int DEFAULT_MAX_RETRIES = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_UNCOMMITTED_OFFSETS = 10000;
    private final Map<String, Object> kafkaProps;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private final long pollTimeoutMs;
    private final long offsetCommitPeriodMs;
    private final int maxRetries;
    private final int maxUncommittedOffsets;
    private final FirstPollOffsetStrategy firstPollOffsetStrategy;
    private final KafkaSpoutStreams kafkaSpoutStreams;
    private final KafkaSpoutTuplesBuilder<K, V> tuplesBuilder;
    private final KafkaSpoutRetryService retryService;

    private KafkaSpoutConfig(Builder<K, V> builder) {
        this.kafkaProps = this.setDefaultsAndGetKafkaProps(((Builder)builder).kafkaProps);
        this.keyDeserializer = ((Builder)builder).keyDeserializer;
        this.valueDeserializer = ((Builder)builder).valueDeserializer;
        this.pollTimeoutMs = ((Builder)builder).pollTimeoutMs;
        this.offsetCommitPeriodMs = ((Builder)builder).offsetCommitPeriodMs;
        this.maxRetries = ((Builder)builder).maxRetries;
        this.firstPollOffsetStrategy = ((Builder)builder).firstPollOffsetStrategy;
        this.kafkaSpoutStreams = ((Builder)builder).kafkaSpoutStreams;
        this.maxUncommittedOffsets = ((Builder)builder).maxUncommittedOffsets;
        this.tuplesBuilder = ((Builder)builder).tuplesBuilder;
        this.retryService = ((Builder)builder).retryService;
    }

    private Map<String, Object> setDefaultsAndGetKafkaProps(Map<String, Object> kafkaProps) {
        if (!kafkaProps.containsKey("enable.auto.commit")) {
            kafkaProps.put("enable.auto.commit", "false");
        }
        return kafkaProps;
    }

    public Map<String, Object> getKafkaProps() {
        return this.kafkaProps;
    }

    public Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public Deserializer<V> getValueDeserializer() {
        return this.valueDeserializer;
    }

    public long getPollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public long getOffsetsCommitPeriodMs() {
        return this.offsetCommitPeriodMs;
    }

    public boolean isConsumerAutoCommitMode() {
        return this.kafkaProps.get("enable.auto.commit") == null || Boolean.valueOf((String)this.kafkaProps.get("enable.auto.commit")) != false;
    }

    public String getConsumerGroupId() {
        return (String)this.kafkaProps.get("group.id");
    }

    public List<String> getSubscribedTopics() {
        return new ArrayList<String>(this.kafkaSpoutStreams.getTopics());
    }

    public int getMaxTupleRetries() {
        return this.maxRetries;
    }

    public FirstPollOffsetStrategy getFirstPollOffsetStrategy() {
        return this.firstPollOffsetStrategy;
    }

    public KafkaSpoutStreams getKafkaSpoutStreams() {
        return this.kafkaSpoutStreams;
    }

    public int getMaxUncommittedOffsets() {
        return this.maxUncommittedOffsets;
    }

    public KafkaSpoutTuplesBuilder<K, V> getTuplesBuilder() {
        return this.tuplesBuilder;
    }

    public KafkaSpoutRetryService getRetryService() {
        return this.retryService;
    }

    public String toString() {
        return "KafkaSpoutConfig{kafkaProps=" + this.kafkaProps + ", keyDeserializer=" + this.keyDeserializer + ", valueDeserializer=" + this.valueDeserializer + ", topics=" + this.getSubscribedTopics() + ", firstPollOffsetStrategy=" + (Object)((Object)this.firstPollOffsetStrategy) + ", pollTimeoutMs=" + this.pollTimeoutMs + ", offsetCommitPeriodMs=" + this.offsetCommitPeriodMs + ", maxRetries=" + this.maxRetries + '}';
    }

    public static class Builder<K, V> {
        private final Map<String, Object> kafkaProps;
        private Deserializer<K> keyDeserializer;
        private Deserializer<V> valueDeserializer;
        private long pollTimeoutMs = 2000L;
        private long offsetCommitPeriodMs = 15000L;
        private int maxRetries = Integer.MAX_VALUE;
        private FirstPollOffsetStrategy firstPollOffsetStrategy = FirstPollOffsetStrategy.UNCOMMITTED_EARLIEST;
        private final KafkaSpoutStreams kafkaSpoutStreams;
        private int maxUncommittedOffsets = 10000;
        private final KafkaSpoutTuplesBuilder<K, V> tuplesBuilder;
        private final KafkaSpoutRetryService retryService;

        public Builder(Map<String, Object> kafkaProps, KafkaSpoutStreams kafkaSpoutStreams, KafkaSpoutTuplesBuilder<K, V> tuplesBuilder) {
            this(kafkaProps, kafkaSpoutStreams, tuplesBuilder, new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds(0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds(2L), Integer.MAX_VALUE, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds(10L)));
        }

        public Builder(Map<String, Object> kafkaProps, KafkaSpoutStreams kafkaSpoutStreams, KafkaSpoutTuplesBuilder<K, V> tuplesBuilder, KafkaSpoutRetryService retryService) {
            if (kafkaProps == null || kafkaProps.isEmpty()) {
                throw new IllegalArgumentException("Properties defining consumer connection to Kafka broker are required: " + kafkaProps);
            }
            if (kafkaSpoutStreams == null) {
                throw new IllegalArgumentException("Must specify stream associated with each topic. Multiple topics can emit to the same stream");
            }
            if (tuplesBuilder == null) {
                throw new IllegalArgumentException("Must specify at last one tuple builder per topic declared in KafkaSpoutStreams");
            }
            if (retryService == null) {
                throw new IllegalArgumentException("Must specify at implementation of retry service");
            }
            this.kafkaProps = kafkaProps;
            this.kafkaSpoutStreams = kafkaSpoutStreams;
            this.tuplesBuilder = tuplesBuilder;
            this.retryService = retryService;
        }

        public Builder<K, V> setKeyDeserializer(Deserializer<K> keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
            return this;
        }

        public Builder<K, V> setValueDeserializer(Deserializer<V> valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
            return this;
        }

        public Builder<K, V> setPollTimeoutMs(long pollTimeoutMs) {
            this.pollTimeoutMs = pollTimeoutMs;
            return this;
        }

        public Builder<K, V> setOffsetCommitPeriodMs(long offsetCommitPeriodMs) {
            this.offsetCommitPeriodMs = offsetCommitPeriodMs;
            return this;
        }

        public Builder<K, V> setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder<K, V> setMaxUncommittedOffsets(int maxUncommittedOffsets) {
            this.maxUncommittedOffsets = maxUncommittedOffsets;
            return this;
        }

        public Builder<K, V> setFirstPollOffsetStrategy(FirstPollOffsetStrategy firstPollOffsetStrategy) {
            this.firstPollOffsetStrategy = firstPollOffsetStrategy;
            return this;
        }

        public KafkaSpoutConfig<K, V> build() {
            return new KafkaSpoutConfig(this);
        }
    }

    public static enum FirstPollOffsetStrategy {
        EARLIEST,
        LATEST,
        UNCOMMITTED_EARLIEST,
        UNCOMMITTED_LATEST;

    }

    public static interface Consumer {
        public static final String GROUP_ID = "group.id";
        public static final String BOOTSTRAP_SERVERS = "bootstrap.servers";
        public static final String ENABLE_AUTO_COMMIT = "enable.auto.commit";
        public static final String AUTO_COMMIT_INTERVAL_MS = "auto.commit.interval.ms";
        public static final String KEY_DESERIALIZER = "key.deserializer";
        public static final String VALUE_DESERIALIZER = "value.deserializer";
    }
}

