/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.Serializable;
import org.apache.storm.tuple.Fields;

public class KafkaSpoutStream
implements Serializable {
    private final Fields outputFields;
    private final String streamId;
    private final String topic;

    KafkaSpoutStream(Fields outputFields, String topic) {
        this(outputFields, "default", topic);
    }

    KafkaSpoutStream(Fields outputFields, String streamId, String topic) {
        if (outputFields == null || streamId == null || topic == null) {
            throw new IllegalArgumentException(String.format("Constructor parameters cannot be null. [outputFields=%s, streamId=%s, topic=%s]", outputFields, streamId, topic));
        }
        this.outputFields = outputFields;
        this.streamId = streamId;
        this.topic = topic;
    }

    Fields getOutputFields() {
        return this.outputFields;
    }

    String getStreamId() {
        return this.streamId;
    }

    String getTopic() {
        return this.topic;
    }

    public String toString() {
        return "KafkaSpoutStream{outputFields=" + this.outputFields + ", streamId='" + this.streamId + '\'' + ", topic='" + this.topic + '\'' + '}';
    }
}

