/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.KafkaSpoutStream;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpoutStreams
implements Serializable {
    protected static final Logger LOG = LoggerFactory.getLogger(KafkaSpoutStreams.class);
    private final Map<String, KafkaSpoutStream> topicToStream;

    private KafkaSpoutStreams(Builder builder) {
        this.topicToStream = builder.topicToStream;
        LOG.debug("Built {}", (Object)this);
    }

    public Fields getOutputFields(String topic) {
        if (this.topicToStream.containsKey(topic)) {
            Fields outputFields = this.topicToStream.get(topic).getOutputFields();
            LOG.trace("Topic [{}] has output fields [{}]", (Object)topic, (Object)outputFields);
            return outputFields;
        }
        throw new IllegalStateException(this.getClass().getName() + " not configured for topic: " + topic);
    }

    public String getStreamId(String topic) {
        if (this.topicToStream.containsKey(topic)) {
            String streamId = this.topicToStream.get(topic).getStreamId();
            LOG.trace("Topic [{}] emitting in stream [{}]", (Object)topic, (Object)streamId);
            return streamId;
        }
        throw new IllegalStateException(this.getClass().getName() + " not configured for topic: " + topic);
    }

    public List<String> getTopics() {
        return new ArrayList<String>(this.topicToStream.keySet());
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (KafkaSpoutStream stream : this.topicToStream.values()) {
            if (((OutputFieldsGetter)declarer).getFieldsDeclaration().containsKey(stream.getStreamId())) continue;
            declarer.declareStream(stream.getStreamId(), stream.getOutputFields());
            LOG.debug("Declared " + stream);
        }
    }

    public void emit(SpoutOutputCollector collector, List<Object> tuple, KafkaSpoutMessageId messageId) {
        collector.emit(this.getStreamId(messageId.topic()), tuple, (Object)messageId);
    }

    public String toString() {
        return "KafkaSpoutStreams{topicToStream=" + this.topicToStream + '}';
    }

    public static class Builder {
        private final Map<String, KafkaSpoutStream> topicToStream = new HashMap<String, KafkaSpoutStream>();

        public Builder(Fields outputFields, String ... topics) {
            this.addStream(outputFields, topics);
        }

        public Builder(Fields outputFields, String streamId, String ... topics) {
            this.addStream(outputFields, streamId, topics);
        }

        public Builder(KafkaSpoutStream stream) {
            this.addStream(stream);
        }

        public Builder addStream(KafkaSpoutStream stream) {
            this.topicToStream.put(stream.getTopic(), stream);
            return this;
        }

        public Builder addStream(Fields outputFields, String ... topics) {
            this.addStream(outputFields, "default", topics);
            return this;
        }

        public Builder addStream(Fields outputFields, String streamId, String ... topics) {
            for (String topic : topics) {
                this.topicToStream.put(topic, new KafkaSpoutStream(outputFields, streamId, topic));
            }
            return this;
        }

        public KafkaSpoutStreams build() {
            return new KafkaSpoutStreams(this);
        }
    }
}

