/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.kafka.spout.KafkaSpoutTupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpoutTuplesBuilder<K, V>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSpoutTuplesBuilder.class);
    private Map<String, KafkaSpoutTupleBuilder<K, V>> topicToTupleBuilders;

    private KafkaSpoutTuplesBuilder(Builder<K, V> builder) {
        this.topicToTupleBuilders = ((Builder)builder).topicToTupleBuilders;
        LOG.debug("Instantiated {}", (Object)this);
    }

    public List<Object> buildTuple(ConsumerRecord<K, V> consumerRecord) {
        String topic = consumerRecord.topic();
        return this.topicToTupleBuilders.get(topic).buildTuple(consumerRecord);
    }

    public String toString() {
        return "KafkaSpoutTuplesBuilder{topicToTupleBuilders=" + this.topicToTupleBuilders + '}';
    }

    public static class Builder<K, V> {
        private List<KafkaSpoutTupleBuilder<K, V>> tupleBuilders;
        private Map<String, KafkaSpoutTupleBuilder<K, V>> topicToTupleBuilders;

        @SafeVarargs
        public Builder(KafkaSpoutTupleBuilder<K, V> ... tupleBuilders) {
            if (tupleBuilders == null || tupleBuilders.length == 0) {
                throw new IllegalArgumentException("Must specify at last one tuple builder per topic declared in KafkaSpoutStreams");
            }
            this.tupleBuilders = Arrays.asList(tupleBuilders);
            this.topicToTupleBuilders = new HashMap<String, KafkaSpoutTupleBuilder<K, V>>();
        }

        public KafkaSpoutTuplesBuilder<K, V> build() {
            for (KafkaSpoutTupleBuilder<K, V> tupleBuilder : this.tupleBuilders) {
                for (String topic : tupleBuilder.getTopics()) {
                    if (this.topicToTupleBuilders.containsKey(topic)) continue;
                    this.topicToTupleBuilders.put(topic, tupleBuilder);
                }
            }
            return new KafkaSpoutTuplesBuilder(this);
        }
    }
}

