/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;

public class KafkaSpoutMessageId {
    private transient TopicPartition topicPart;
    private transient long offset;
    private transient int numFails = 0;

    public KafkaSpoutMessageId(ConsumerRecord consumerRecord) {
        this(new TopicPartition(consumerRecord.topic(), consumerRecord.partition()), consumerRecord.offset());
    }

    public KafkaSpoutMessageId(TopicPartition topicPart, long offset) {
        this.topicPart = topicPart;
        this.offset = offset;
    }

    public int partition() {
        return this.topicPart.partition();
    }

    public String topic() {
        return this.topicPart.topic();
    }

    public long offset() {
        return this.offset;
    }

    public int numFails() {
        return this.numFails;
    }

    public void incrementNumFails() {
        ++this.numFails;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPart;
    }

    public String getMetadata(Thread currThread) {
        return "{topic-partition=" + this.topicPart + ", offset=" + this.offset + ", numFails=" + this.numFails + ", thread='" + currThread.getName() + "'" + '}';
    }

    public String toString() {
        return "{topic-partition=" + this.topicPart + ", offset=" + this.offset + ", numFails=" + this.numFails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSpoutMessageId messageId = (KafkaSpoutMessageId)o;
        if (this.offset != messageId.offset) {
            return false;
        }
        return this.topicPart.equals((Object)messageId.topicPart);
    }

    public int hashCode() {
        int result = this.topicPart.hashCode();
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }
}

