/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.kafka.spout.KafkaSpoutStream;
import org.apache.storm.kafka.spout.KafkaSpoutStreams;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.topology.OutputFieldsDeclarer;

public class KafkaSpoutStreamsWildcardTopics
implements KafkaSpoutStreams {
    private KafkaSpoutStream kafkaSpoutStream;

    public KafkaSpoutStreamsWildcardTopics(KafkaSpoutStream kafkaSpoutStream) {
        this.kafkaSpoutStream = kafkaSpoutStream;
        if (kafkaSpoutStream.getTopicWildcardPattern() == null) {
            throw new IllegalStateException("KafkaSpoutStream must be configured for wildcard topic");
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.kafkaSpoutStream.declareOutputFields(declarer);
    }

    @Override
    public void emit(SpoutOutputCollector collector, List<Object> tuple, KafkaSpoutMessageId messageId) {
        this.kafkaSpoutStream.emit(collector, tuple, messageId);
    }

    public KafkaSpoutStream getStream() {
        return this.kafkaSpoutStream;
    }

    public Pattern getTopicWildcardPattern() {
        return this.kafkaSpoutStream.getTopicWildcardPattern();
    }

    public String toString() {
        return "KafkaSpoutStreamsWildcardTopics{kafkaSpoutStream=" + this.kafkaSpoutStream + '}';
    }
}

