/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.storm.kafka.spout.KafkaSpoutMessageId;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpoutStream
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSpoutStream.class);
    private final Fields outputFields;
    private final String streamId;
    private final String topic;
    private Pattern topicWildcardPattern;

    public KafkaSpoutStream(Fields outputFields, String topic) {
        this(outputFields, "default", topic);
    }

    public KafkaSpoutStream(Fields outputFields, String streamId, String topic) {
        if (outputFields == null || streamId == null || topic == null) {
            throw new IllegalArgumentException(String.format("Constructor parameters cannot be null. [outputFields=%s, streamId=%s, topic=%s]", outputFields, streamId, topic));
        }
        this.outputFields = outputFields;
        this.streamId = streamId;
        this.topic = topic;
        this.topicWildcardPattern = null;
    }

    KafkaSpoutStream(Fields outputFields, Pattern topicWildcardPattern) {
        this(outputFields, "default", topicWildcardPattern);
    }

    public KafkaSpoutStream(Fields outputFields, String streamId, Pattern topicWildcardPattern) {
        if (outputFields == null || streamId == null || topicWildcardPattern == null) {
            throw new IllegalArgumentException(String.format("Constructor parameters cannot be null. [outputFields=%s, streamId=%s, topicWildcardPattern=%s]", outputFields, streamId, topicWildcardPattern));
        }
        this.outputFields = outputFields;
        this.streamId = streamId;
        this.topic = null;
        this.topicWildcardPattern = topicWildcardPattern;
    }

    public void emit(SpoutOutputCollector collector, List<Object> tuple, KafkaSpoutMessageId messageId) {
        collector.emit(this.streamId, tuple, (Object)messageId);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        LOG.info("Declared [streamId = {}], [outputFields = {}] for [topic = {}]", new Object[]{this.streamId, this.outputFields, this.topic});
        declarer.declareStream(this.streamId, this.outputFields);
    }

    public Fields getOutputFields() {
        return this.outputFields;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getTopic() {
        return this.topic;
    }

    public Pattern getTopicWildcardPattern() {
        return this.topicWildcardPattern;
    }

    public String toString() {
        return "KafkaSpoutStream{outputFields=" + this.outputFields + ", streamId='" + this.streamId + '\'' + ", topic='" + this.topic + '\'' + ", topicWildcardPattern=" + this.topicWildcardPattern + '}';
    }
}

