/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.kafka.spout.KafkaSpoutTupleBuilder;
import org.apache.storm.kafka.spout.KafkaSpoutTuplesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpoutTuplesBuilderNamedTopics<K, V>
implements KafkaSpoutTuplesBuilder<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSpoutTuplesBuilderNamedTopics.class);
    private Map<String, KafkaSpoutTupleBuilder<K, V>> topicToTupleBuilders;

    private KafkaSpoutTuplesBuilderNamedTopics(Builder<K, V> builder) {
        this.topicToTupleBuilders = ((Builder)builder).topicToTupleBuilders;
        LOG.debug("Instantiated {}", (Object)this);
    }

    @Override
    public List<Object> buildTuple(ConsumerRecord<K, V> consumerRecord) {
        String topic = consumerRecord.topic();
        return this.topicToTupleBuilders.get(topic).buildTuple(consumerRecord);
    }

    public String toString() {
        return "KafkaSpoutTuplesBuilderNamedTopics {topicToTupleBuilders=" + this.topicToTupleBuilders + '}';
    }

    public static class Builder<K, V> {
        private List<KafkaSpoutTupleBuilder<K, V>> tupleBuilders;
        private Map<String, KafkaSpoutTupleBuilder<K, V>> topicToTupleBuilders;

        @SafeVarargs
        public Builder(KafkaSpoutTupleBuilder<K, V> ... tupleBuilders) {
            if (tupleBuilders == null || tupleBuilders.length == 0) {
                throw new IllegalArgumentException("Must specify at last one tuple builder per topic declared in KafkaSpoutStreams");
            }
            this.tupleBuilders = Arrays.asList(tupleBuilders);
            this.topicToTupleBuilders = new HashMap<String, KafkaSpoutTupleBuilder<K, V>>();
        }

        public KafkaSpoutTuplesBuilderNamedTopics<K, V> build() {
            for (KafkaSpoutTupleBuilder<K, V> tupleBuilder : this.tupleBuilders) {
                for (String topic : tupleBuilder.getTopics()) {
                    if (this.topicToTupleBuilders.containsKey(topic)) continue;
                    this.topicToTupleBuilders.put(topic, tupleBuilder);
                }
            }
            return new KafkaSpoutTuplesBuilderNamedTopics(this);
        }
    }
}

