/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.TopicFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedTopicFilter
implements TopicFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NamedTopicFilter.class);
    private final Set<String> topics;

    public NamedTopicFilter(Set<String> topics) {
        this.topics = Collections.unmodifiableSet(topics);
    }

    public NamedTopicFilter(String ... topics) {
        this(new HashSet<String>(Arrays.asList(topics)));
    }

    @Override
    public List<TopicPartition> getFilteredTopicPartitions(KafkaConsumer<?, ?> consumer) {
        ArrayList<TopicPartition> allPartitions = new ArrayList<TopicPartition>();
        for (String topic : this.topics) {
            List partitionInfoList = consumer.partitionsFor(topic);
            if (partitionInfoList != null) {
                for (PartitionInfo partitionInfo : partitionInfoList) {
                    allPartitions.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
                }
                continue;
            }
            LOG.warn("Topic {} not found, skipping addition of the topic", (Object)topic);
        }
        return allPartitions;
    }

    @Override
    public String getTopicsString() {
        return StringUtils.join(this.topics, (String)",");
    }
}

