/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.kafka.spout.DefaultRecordTranslator;
import org.apache.storm.kafka.spout.FirstPollOffsetStrategy;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.kafka.spout.RecordTranslator;
import org.apache.storm.kafka.spout.SimpleRecordTranslator;
import org.apache.storm.kafka.spout.subscription.ManualPartitioner;
import org.apache.storm.kafka.spout.subscription.NamedTopicFilter;
import org.apache.storm.kafka.spout.subscription.PatternTopicFilter;
import org.apache.storm.kafka.spout.subscription.RoundRobinManualPartitioner;
import org.apache.storm.kafka.spout.subscription.TopicFilter;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonKafkaSpoutConfig<K, V>
implements Serializable {
    public static final long DEFAULT_POLL_TIMEOUT_MS = 200L;
    public static final long DEFAULT_PARTITION_REFRESH_PERIOD_MS = 2000L;
    public static final FirstPollOffsetStrategy DEFAULT_FIRST_POLL_OFFSET_STRATEGY = FirstPollOffsetStrategy.UNCOMMITTED_EARLIEST;
    public static final Logger LOG = LoggerFactory.getLogger(CommonKafkaSpoutConfig.class);
    private final Map<String, Object> kafkaProps;
    private final TopicFilter topicFilter;
    private final ManualPartitioner topicPartitioner;
    private final long pollTimeoutMs;
    private final RecordTranslator<K, V> translator;
    private final FirstPollOffsetStrategy firstPollOffsetStrategy;
    private final long partitionRefreshPeriodMs;

    public CommonKafkaSpoutConfig(Builder<K, V, ?> builder) {
        this.kafkaProps = ((Builder)builder).kafkaProps;
        this.topicFilter = ((Builder)builder).topicFilter;
        this.topicPartitioner = ((Builder)builder).topicPartitioner;
        this.translator = ((Builder)builder).translator;
        this.firstPollOffsetStrategy = ((Builder)builder).firstPollOffsetStrategy;
        this.pollTimeoutMs = ((Builder)builder).pollTimeoutMs;
        this.partitionRefreshPeriodMs = ((Builder)builder).partitionRefreshPeriodMs;
    }

    public Map<String, Object> getKafkaProps() {
        return this.kafkaProps;
    }

    public TopicFilter getTopicFilter() {
        return this.topicFilter;
    }

    public ManualPartitioner getTopicPartitioner() {
        return this.topicPartitioner;
    }

    public RecordTranslator<K, V> getTranslator() {
        return this.translator;
    }

    public FirstPollOffsetStrategy getFirstPollOffsetStrategy() {
        return this.firstPollOffsetStrategy;
    }

    public long getPollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public long getPartitionRefreshPeriodMs() {
        return this.partitionRefreshPeriodMs;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("kafkaProps", this.kafkaProps).append("partitionRefreshPeriodMs", this.partitionRefreshPeriodMs).append("pollTimeoutMs", this.pollTimeoutMs).append("topicFilter", (Object)this.topicFilter).append("topicPartitioner", (Object)this.topicPartitioner).append("translator", this.translator).toString();
    }

    public static abstract class Builder<K, V, T extends Builder<K, V, T>> {
        private final Map<String, Object> kafkaProps;
        private final TopicFilter topicFilter;
        private final ManualPartitioner topicPartitioner;
        private RecordTranslator<K, V> translator;
        private long pollTimeoutMs = 200L;
        private FirstPollOffsetStrategy firstPollOffsetStrategy = DEFAULT_FIRST_POLL_OFFSET_STRATEGY;
        private long partitionRefreshPeriodMs = 2000L;

        public Builder(String bootstrapServers, String ... topics) {
            this(bootstrapServers, new NamedTopicFilter(topics), new RoundRobinManualPartitioner());
        }

        public Builder(String bootstrapServers, Set<String> topics) {
            this(bootstrapServers, new NamedTopicFilter(topics), new RoundRobinManualPartitioner());
        }

        public Builder(String bootstrapServers, Pattern topics) {
            this(bootstrapServers, new PatternTopicFilter(topics), new RoundRobinManualPartitioner());
        }

        public Builder(String bootstrapServers, TopicFilter topicFilter, ManualPartitioner topicPartitioner) {
            this.kafkaProps = new HashMap<String, Object>();
            if (bootstrapServers == null || bootstrapServers.isEmpty()) {
                throw new IllegalArgumentException("bootstrap servers cannot be null");
            }
            this.kafkaProps.put("bootstrap.servers", bootstrapServers);
            this.topicFilter = topicFilter;
            this.topicPartitioner = topicPartitioner;
            this.translator = new DefaultRecordTranslator();
        }

        public T setProp(String key, Object value) {
            this.kafkaProps.put(key, value);
            return (T)this;
        }

        public T setProp(Map<String, Object> props) {
            this.kafkaProps.putAll(props);
            return (T)this;
        }

        public T setProp(Properties props) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Kafka Consumer property keys must be Strings");
                }
                this.kafkaProps.put((String)key, value);
            }));
            return (T)this;
        }

        public T setPollTimeoutMs(long pollTimeoutMs) {
            this.pollTimeoutMs = pollTimeoutMs;
            return (T)this;
        }

        public T setFirstPollOffsetStrategy(FirstPollOffsetStrategy firstPollOffsetStrategy) {
            this.firstPollOffsetStrategy = firstPollOffsetStrategy;
            return (T)this;
        }

        public T setRecordTranslator(RecordTranslator<K, V> translator) {
            this.translator = translator;
            return (T)this;
        }

        public T setRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields) {
            return this.setRecordTranslator(new SimpleRecordTranslator<K, V>(func, fields));
        }

        public T setRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields, String stream) {
            return this.setRecordTranslator(new SimpleRecordTranslator<K, V>(func, fields, stream));
        }

        public T setPartitionRefreshPeriodMs(long partitionRefreshPeriodMs) {
            this.partitionRefreshPeriodMs = partitionRefreshPeriodMs;
            return (T)this;
        }

        protected Map<String, Object> getKafkaProps() {
            return this.kafkaProps;
        }

        public abstract CommonKafkaSpoutConfig<K, V> build();
    }
}

