/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.metrics2;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.storm.kafka.spout.internal.OffsetManager;
import org.apache.storm.kafka.spout.metrics2.KafkaOffsetTopicMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetPartitionMetrics<K, V>
implements MetricSet {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaOffsetPartitionMetrics.class);
    private final Supplier<Map<TopicPartition, OffsetManager>> offsetManagerSupplier;
    private final Supplier<Consumer<K, V>> consumerSupplier;
    private TopicPartition topicPartition;
    private KafkaOffsetTopicMetrics topicMetrics;

    public KafkaOffsetPartitionMetrics(Supplier<Map<TopicPartition, OffsetManager>> offsetManagerSupplier, Supplier<Consumer<K, V>> consumerSupplier, TopicPartition topicPartition, KafkaOffsetTopicMetrics topicMetrics) {
        this.offsetManagerSupplier = offsetManagerSupplier;
        this.consumerSupplier = consumerSupplier;
        this.topicPartition = topicPartition;
        this.topicMetrics = topicMetrics;
        LOG.info("Running KafkaOffsetMetricSet");
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        String metricPath = this.topicPartition.topic() + "/partition_" + this.topicPartition.partition();
        Gauge<Long> spoutLagGauge = new Gauge<Long>(){

            public Long getValue() {
                Map<TopicPartition, Long> endOffsets = KafkaOffsetPartitionMetrics.this.getEndOffsets(Collections.singleton(KafkaOffsetPartitionMetrics.this.topicPartition));
                if (endOffsets == null || endOffsets.isEmpty()) {
                    LOG.error("Failed to get endOffsets from Kafka for topic partitions: {}.", (Object)KafkaOffsetPartitionMetrics.this.topicPartition);
                    return 0L;
                }
                OffsetManager offsetManager = KafkaOffsetPartitionMetrics.this.offsetManagerSupplier.get().get(KafkaOffsetPartitionMetrics.this.topicPartition);
                Long ret = endOffsets.get(KafkaOffsetPartitionMetrics.this.topicPartition) - offsetManager.getCommittedOffset();
                KafkaOffsetPartitionMetrics.this.topicMetrics.totalSpoutLag += ret.longValue();
                return ret;
            }
        };
        Gauge<Long> earliestTimeOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                Map<TopicPartition, Long> beginningOffsets = KafkaOffsetPartitionMetrics.this.getBeginningOffsets(Collections.singleton(KafkaOffsetPartitionMetrics.this.topicPartition));
                if (beginningOffsets == null || beginningOffsets.isEmpty()) {
                    LOG.error("Failed to get beginningOffsets from Kafka for topic partitions: {}.", (Object)KafkaOffsetPartitionMetrics.this.topicPartition);
                    return 0L;
                }
                Long ret = beginningOffsets.get(KafkaOffsetPartitionMetrics.this.topicPartition);
                KafkaOffsetPartitionMetrics.this.topicMetrics.totalEarliestTimeOffset += beginningOffsets.get(KafkaOffsetPartitionMetrics.this.topicPartition).longValue();
                return ret;
            }
        };
        Gauge<Long> latestTimeOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                Map<TopicPartition, Long> endOffsets = KafkaOffsetPartitionMetrics.this.getEndOffsets(Collections.singleton(KafkaOffsetPartitionMetrics.this.topicPartition));
                if (endOffsets == null || endOffsets.isEmpty()) {
                    LOG.error("Failed to get endOffsets from Kafka for topic partitions: {}.", (Object)KafkaOffsetPartitionMetrics.this.topicPartition);
                    return 0L;
                }
                Long ret = endOffsets.get(KafkaOffsetPartitionMetrics.this.topicPartition);
                KafkaOffsetPartitionMetrics.this.topicMetrics.totalLatestTimeOffset += ret.longValue();
                return ret;
            }
        };
        Gauge<Long> latestEmittedOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                OffsetManager offsetManager = KafkaOffsetPartitionMetrics.this.offsetManagerSupplier.get().get(KafkaOffsetPartitionMetrics.this.topicPartition);
                Long ret = offsetManager.getLatestEmittedOffset();
                KafkaOffsetPartitionMetrics.this.topicMetrics.totalLatestEmittedOffset += ret.longValue();
                return ret;
            }
        };
        Gauge<Long> latestCompletedOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                OffsetManager offsetManager = KafkaOffsetPartitionMetrics.this.offsetManagerSupplier.get().get(KafkaOffsetPartitionMetrics.this.topicPartition);
                Long ret = offsetManager.getCommittedOffset();
                KafkaOffsetPartitionMetrics.this.topicMetrics.totalLatestCompletedOffset += ret.longValue();
                return ret;
            }
        };
        Gauge<Long> recordsInPartitionGauge = new Gauge<Long>(){

            public Long getValue() {
                Map<TopicPartition, Long> endOffsets = KafkaOffsetPartitionMetrics.this.getEndOffsets(Collections.singleton(KafkaOffsetPartitionMetrics.this.topicPartition));
                if (endOffsets == null || endOffsets.isEmpty()) {
                    LOG.error("Failed to get endOffsets from Kafka for topic partitions: {}.", (Object)KafkaOffsetPartitionMetrics.this.topicPartition);
                    return 0L;
                }
                Map<TopicPartition, Long> beginningOffsets = KafkaOffsetPartitionMetrics.this.getBeginningOffsets(Collections.singleton(KafkaOffsetPartitionMetrics.this.topicPartition));
                if (beginningOffsets == null || beginningOffsets.isEmpty()) {
                    LOG.error("Failed to get beginningOffsets from Kafka for topic partitions: {}.", (Object)KafkaOffsetPartitionMetrics.this.topicPartition);
                    return 0L;
                }
                Long ret = endOffsets.get(KafkaOffsetPartitionMetrics.this.topicPartition) - beginningOffsets.get(KafkaOffsetPartitionMetrics.this.topicPartition);
                KafkaOffsetPartitionMetrics.this.topicMetrics.totalRecordsInPartitions += ret.longValue();
                return ret;
            }
        };
        metrics.put(metricPath + "/spoutLag", (Metric)spoutLagGauge);
        metrics.put(metricPath + "/earliestTimeOffset", (Metric)earliestTimeOffsetGauge);
        metrics.put(metricPath + "/latestTimeOffset", (Metric)latestTimeOffsetGauge);
        metrics.put(metricPath + "/latestEmittedOffset", (Metric)latestEmittedOffsetGauge);
        metrics.put(metricPath + "/latestCompletedOffset", (Metric)latestCompletedOffsetGauge);
        metrics.put(metricPath + "/recordsInPartition", (Metric)recordsInPartitionGauge);
        return metrics;
    }

    private Map<TopicPartition, Long> getBeginningOffsets(Set<TopicPartition> topicPartitions) {
        Map beginningOffsets;
        Consumer<K, V> consumer = this.consumerSupplier.get();
        if (consumer == null) {
            LOG.error("Kafka consumer object is null, returning 0.");
            return Collections.EMPTY_MAP;
        }
        try {
            beginningOffsets = consumer.beginningOffsets(topicPartitions);
        }
        catch (RetriableException e) {
            LOG.error("Failed to get offset from Kafka for topic partitions: {}.", (Object)this.topicPartition, (Object)e);
            return Collections.EMPTY_MAP;
        }
        return beginningOffsets;
    }

    private Map<TopicPartition, Long> getEndOffsets(Set<TopicPartition> topicPartitions) {
        Map endOffsets;
        Consumer<K, V> consumer = this.consumerSupplier.get();
        if (consumer == null) {
            LOG.error("Kafka consumer object is null, returning 0.");
            return Collections.EMPTY_MAP;
        }
        try {
            endOffsets = consumer.endOffsets(topicPartitions);
        }
        catch (RetriableException e) {
            LOG.error("Failed to get offset from Kafka for topic partitions: {}.", (Object)this.topicPartition, (Object)e);
            return Collections.EMPTY_MAP;
        }
        return endOffsets;
    }
}

