/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.metrics2;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetTopicMetrics
implements MetricSet {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaOffsetTopicMetrics.class);
    private String topic;
    long totalSpoutLag;
    long totalEarliestTimeOffset;
    long totalLatestTimeOffset;
    long totalLatestEmittedOffset;
    long totalLatestCompletedOffset;
    long totalRecordsInPartitions;

    public KafkaOffsetTopicMetrics(String topic) {
        this.topic = topic;
        this.totalSpoutLag = 0L;
        this.totalEarliestTimeOffset = 0L;
        this.totalLatestTimeOffset = 0L;
        this.totalLatestEmittedOffset = 0L;
        this.totalLatestCompletedOffset = 0L;
        this.totalRecordsInPartitions = 0L;
        LOG.info("Create KafkaOffsetTopicMetrics for topic: {}", (Object)topic);
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        Gauge<Long> totalSpoutLagGauge = new Gauge<Long>(){

            public Long getValue() {
                return KafkaOffsetTopicMetrics.this.totalSpoutLag;
            }
        };
        Gauge<Long> totalEarliestTimeOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                return KafkaOffsetTopicMetrics.this.totalEarliestTimeOffset;
            }
        };
        Gauge<Long> totalLatestTimeOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                return KafkaOffsetTopicMetrics.this.totalLatestTimeOffset;
            }
        };
        Gauge<Long> totalLatestEmittedOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                return KafkaOffsetTopicMetrics.this.totalLatestEmittedOffset;
            }
        };
        Gauge<Long> totalLatestCompletedOffsetGauge = new Gauge<Long>(){

            public Long getValue() {
                return KafkaOffsetTopicMetrics.this.totalLatestCompletedOffset;
            }
        };
        Gauge<Long> totalRecordsInPartitionsGauge = new Gauge<Long>(){

            public Long getValue() {
                return KafkaOffsetTopicMetrics.this.totalRecordsInPartitions;
            }
        };
        metrics.put(this.topic + "/totalSpoutLag", (Metric)totalSpoutLagGauge);
        metrics.put(this.topic + "/totalEarliestTimeOffset", (Metric)totalEarliestTimeOffsetGauge);
        metrics.put(this.topic + "/totalLatestTimeOffset", (Metric)totalLatestTimeOffsetGauge);
        metrics.put(this.topic + "/totalLatestEmittedOffset", (Metric)totalLatestEmittedOffsetGauge);
        metrics.put(this.topic + "/totalLatestCompletedOffset", (Metric)totalLatestCompletedOffsetGauge);
        metrics.put(this.topic + "/totalRecordsInPartitions", (Metric)totalRecordsInPartitionsGauge);
        return metrics;
    }

    private class TopicMetrics {
        long totalSpoutLag = 0L;
        long totalEarliestTimeOffset = 0L;
        long totalLatestTimeOffset = 0L;
        long totalLatestEmittedOffset = 0L;
        long totalLatestCompletedOffset = 0L;
        long totalRecordsInPartitions = 0L;

        private TopicMetrics() {
        }

        public void incrementTotalSpoutLag(long offset) {
            this.totalSpoutLag += offset;
        }

        public void incrementTotalEarliestTimeOffset(long offset) {
            this.totalEarliestTimeOffset += offset;
        }

        public void incrementTotalLatestTimeOffset(long offset) {
            this.totalLatestTimeOffset += offset;
        }
    }
}

