/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.DaemonConfig;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.daemon.nimbus.Nimbus;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerMemoryTracker;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.daemon.supervisor.ExitCodeCallback;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.shade.com.google.common.base.Joiner;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.SimpleVersion;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicContainer
extends Container {
    static final TopoMetaLRUCache TOPO_META_CACHE = new TopoMetaLRUCache();
    private static final Logger LOG = LoggerFactory.getLogger(BasicContainer.class);
    private static final FilenameFilter jarFilter = (dir, name) -> name.endsWith(".jar");
    private static final Joiner CPJ = Joiner.on((String)File.pathSeparator).skipNulls();
    protected final LocalState _localState;
    protected final String _profileCmd;
    protected final String _stormHome = System.getProperty("storm.home");
    protected final double hardMemoryLimitMultiplier;
    protected final long hardMemoryLimitOver;
    protected final long lowMemoryThresholdMB;
    protected final long mediumMemoryThresholdMb;
    protected final long mediumMemoryGracePeriodMs;
    protected volatile boolean _exitedEarly = false;
    protected volatile long memoryLimitMB;
    protected volatile long memoryLimitExceededStart;

    public BasicContainer(Container.ContainerType type, Map<String, Object> conf, String supervisorId, int supervisorPort, int port, LocalAssignment assignment, ResourceIsolationInterface resourceIsolationManager, LocalState localState, String workerId, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker) throws IOException {
        this(type, conf, supervisorId, supervisorPort, port, assignment, resourceIsolationManager, localState, workerId, metricsRegistry, containerMemoryTracker, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasicContainer(Container.ContainerType type, Map<String, Object> conf, String supervisorId, int supervisorPort, int port, LocalAssignment assignment, ResourceIsolationInterface resourceIsolationManager, LocalState localState, String workerId, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker, Map<String, Object> topoConf, AdvancedFSOps ops, String profileCmd) throws IOException {
        super(type, conf, supervisorId, supervisorPort, port, assignment, resourceIsolationManager, workerId, topoConf, ops, metricsRegistry, containerMemoryTracker);
        assert (localState != null);
        this._localState = localState;
        if (type.isRecovery() && !type.isOnlyKillable()) {
            LocalState localState2 = localState;
            synchronized (localState2) {
                String wid = null;
                Map workerToPort = localState.getApprovedWorkers();
                for (Map.Entry entry : workerToPort.entrySet()) {
                    if (port != (Integer)entry.getValue()) continue;
                    wid = (String)entry.getKey();
                }
                if (wid == null) {
                    throw new ContainerRecoveryException("Could not find worker id for " + port + " " + assignment);
                }
                LOG.info("Recovered Worker {}", wid);
                this._workerId = wid;
            }
        } else if (this._workerId == null) {
            this.createNewWorkerId();
        }
        if (profileCmd == null) {
            profileCmd = this._stormHome + File.separator + "bin" + File.separator + conf.get("worker.profiler.command");
        }
        this._profileCmd = profileCmd;
        this.hardMemoryLimitMultiplier = ObjectReader.getDouble((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_HARD_MEMORY_LIMIT_MULTIPLIER), (Double)2.0);
        this.hardMemoryLimitOver = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_HARD_LIMIT_MEMORY_OVERAGE_MB), (Integer)0).intValue();
        this.lowMemoryThresholdMB = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_LOW_MEMORY_THRESHOLD_MB), (Integer)1024).intValue();
        this.mediumMemoryThresholdMb = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_MEDIUM_MEMORY_THRESHOLD_MB), (Integer)1536).intValue();
        this.mediumMemoryGracePeriodMs = ObjectReader.getInt((Object)conf.get(DaemonConfig.STORM_SUPERVISOR_MEDIUM_MEMORY_GRACE_PERIOD_MS), (Integer)20000).intValue();
        if (assignment != null) {
            WorkerResources resources = assignment.get_resources();
            this.memoryLimitMB = this.calculateMemoryLimit(resources, this.getMemOnHeap(resources));
        }
    }

    private static void removeWorkersOn(Map<String, Integer> workerToPort, int _port) {
        Iterator<Map.Entry<String, Integer>> i = workerToPort.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Integer> found = i.next();
            if (_port != found.getValue()) continue;
            LOG.warn("Deleting worker {} from state", (Object)found.getKey());
            i.remove();
        }
    }

    public static List<String> getDependencyLocationsFor(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) throws IOException {
        return TOPO_META_CACHE.get(conf, topologyId, ops, stormRoot).getDepLocs();
    }

    public static String getStormVersionFor(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) throws IOException {
        return TOPO_META_CACHE.get(conf, topologyId, ops, stormRoot).getStormVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNewWorkerId() {
        this._type.assertFull();
        assert (this._workerId == null);
        LocalState localState = this._localState;
        synchronized (localState) {
            this._workerId = Utils.uuid();
            HashMap<String, Integer> workerToPort = this._localState.getApprovedWorkers();
            if (workerToPort == null) {
                workerToPort = new HashMap<String, Integer>(1);
            }
            BasicContainer.removeWorkersOn((Map<String, Integer>)workerToPort, this._port);
            workerToPort.put(this._workerId, this._port);
            this._localState.setApprovedWorkers(workerToPort);
            LOG.info("Created Worker ID {}", (Object)this._workerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpForRestart() throws IOException {
        String origWorkerId = this._workerId;
        super.cleanUpForRestart();
        LocalState localState = this._localState;
        synchronized (localState) {
            Map workersToPort = this._localState.getApprovedWorkers();
            if (workersToPort != null) {
                workersToPort.remove(origWorkerId);
                BasicContainer.removeWorkersOn(workersToPort, this._port);
                this._localState.setApprovedWorkers(workersToPort);
                LOG.info("Removed Worker ID {}", (Object)origWorkerId);
            } else {
                LOG.warn("No approved workers exists");
            }
        }
    }

    @Override
    public void relaunch() throws IOException {
        this._type.assertFull();
        this._type = Container.ContainerType.LAUNCH;
        this.createNewWorkerId();
        this.setup();
        this.launch();
    }

    @Override
    public boolean didMainProcessExit() {
        return this._exitedEarly;
    }

    protected boolean runProfilingCommand(List<String> command, Map<String, String> env, String logPrefix, File targetDir) throws IOException, InterruptedException {
        this._type.assertFull();
        Process p = ClientSupervisorUtils.launchProcess(command, env, (String)logPrefix, null, (File)targetDir);
        int ret = p.waitFor();
        return ret == 0;
    }

    @Override
    public boolean runProfiling(ProfileRequest request, boolean stop) throws IOException, InterruptedException {
        this._type.assertFull();
        String targetDir = ConfigUtils.workerArtifactsRoot((Map)this._conf, (String)this._topologyId, (Integer)this._port);
        HashMap<String, String> env = (HashMap<String, String>)this._topoConf.get("topology.environment");
        if (env == null) {
            env = new HashMap<String, String>();
        }
        String str = ConfigUtils.workerArtifactsPidPath((Map)this._conf, (String)this._topologyId, (Integer)this._port);
        String workerPid = this._ops.slurpString(new File(str)).trim();
        ProfileAction profileAction = request.get_action();
        String logPrefix = "ProfilerAction process " + this._topologyId + ":" + this._port + " PROFILER_ACTION: " + profileAction + " ";
        List<String> command = this.mkProfileCommand(profileAction, stop, workerPid, targetDir);
        File targetFile = new File(targetDir);
        if (command.size() > 0) {
            return this.runProfilingCommand(command, env, logPrefix, targetFile);
        }
        LOG.warn("PROFILING REQUEST NOT SUPPORTED {} IGNORED...", (Object)request);
        return true;
    }

    private List<String> mkProfileCommand(ProfileAction action, boolean stop, String workerPid, String targetDir) {
        switch (action) {
            case JMAP_DUMP: {
                return this.jmapDumpCmd(workerPid, targetDir);
            }
            case JSTACK_DUMP: {
                return this.jstackDumpCmd(workerPid, targetDir);
            }
            case JPROFILE_DUMP: {
                return this.jprofileDump(workerPid, targetDir);
            }
            case JVM_RESTART: {
                return this.jprofileJvmRestart(workerPid);
            }
            case JPROFILE_STOP: {
                if (stop) {
                    return this.jprofileStop(workerPid, targetDir);
                }
                return this.jprofileStart(workerPid);
            }
        }
        return Lists.newArrayList();
    }

    private List<String> jmapDumpCmd(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this._profileCmd, pid, "jmap", targetDir});
    }

    private List<String> jstackDumpCmd(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this._profileCmd, pid, "jstack", targetDir});
    }

    private List<String> jprofileStart(String pid) {
        return Lists.newArrayList((Object[])new String[]{this._profileCmd, pid, "start"});
    }

    private List<String> jprofileStop(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this._profileCmd, pid, "stop", targetDir});
    }

    private List<String> jprofileDump(String pid, String targetDir) {
        return Lists.newArrayList((Object[])new String[]{this._profileCmd, pid, "dump", targetDir});
    }

    private List<String> jprofileJvmRestart(String pid) {
        return Lists.newArrayList((Object[])new String[]{this._profileCmd, pid, "kill"});
    }

    protected String javaLibraryPath(String stormRoot, Map<String, Object> conf) {
        String resourceRoot = stormRoot + File.separator + "resources";
        String os = System.getProperty("os.name").replaceAll("\\s+", "_");
        String arch = System.getProperty("os.arch");
        String archResourceRoot = resourceRoot + File.separator + os + "-" + arch;
        String ret = CPJ.join((Object)archResourceRoot, (Object)resourceRoot, new Object[]{conf.get("java.library.path")});
        return ret;
    }

    protected String getWildcardDir(File dir) {
        return dir.toString() + File.separator + "*";
    }

    protected List<String> frameworkClasspath(SimpleVersion topoVersion) {
        File stormWorkerLibDir = new File(this._stormHome, "lib-worker");
        String topoConfDir = System.getenv("STORM_CONF_DIR") != null ? System.getenv("STORM_CONF_DIR") : new File(this._stormHome, "conf").getAbsolutePath();
        File stormExtlibDir = new File(this._stormHome, "extlib");
        String extcp = System.getenv("STORM_EXT_CLASSPATH");
        LinkedList<String> pathElements = new LinkedList<String>();
        pathElements.add(this.getWildcardDir(stormWorkerLibDir));
        pathElements.add(this.getWildcardDir(stormExtlibDir));
        pathElements.add(extcp);
        pathElements.add(topoConfDir);
        NavigableMap classpaths = Utils.getConfiguredClasspathVersions((Map)this._conf, pathElements);
        return (List)Utils.getCompatibleVersion((NavigableMap)classpaths, (SimpleVersion)topoVersion, (String)"classpath", pathElements);
    }

    protected String getWorkerMain(SimpleVersion topoVersion) {
        String defaultWorkerGuess = "org.apache.storm.daemon.worker.Worker";
        if (topoVersion.getMajor() == 0) {
            defaultWorkerGuess = "backtype.storm.daemon.worker";
        } else if (topoVersion.getMajor() == 1) {
            defaultWorkerGuess = "org.apache.storm.daemon.worker";
        }
        NavigableMap mains = Utils.getConfiguredWorkerMainVersions((Map)this._conf);
        return (String)Utils.getCompatibleVersion((NavigableMap)mains, (SimpleVersion)topoVersion, (String)"worker main class", (Object)defaultWorkerGuess);
    }

    protected String getWorkerLogWriter(SimpleVersion topoVersion) {
        String defaultGuess = "org.apache.storm.LogWriter";
        if (topoVersion.getMajor() == 0) {
            defaultGuess = "backtype.storm.LogWriter";
        }
        NavigableMap mains = Utils.getConfiguredWorkerLogWriterVersions((Map)this._conf);
        return (String)Utils.getCompatibleVersion((NavigableMap)mains, (SimpleVersion)topoVersion, (String)"worker log writer class", (Object)defaultGuess);
    }

    private List<String> asStringList(Object o) {
        if (o instanceof String) {
            return Arrays.asList((String)o);
        }
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.EMPTY_LIST;
    }

    protected String getWorkerClassPath(String stormJar, List<String> dependencyLocations, SimpleVersion topoVersion) {
        ArrayList<String> workercp = new ArrayList<String>();
        workercp.addAll(this.asStringList(this._topoConf.get("topology.classpath.beginning")));
        workercp.addAll(this.frameworkClasspath(topoVersion));
        workercp.add(stormJar);
        workercp.addAll(dependencyLocations);
        workercp.addAll(this.asStringList(this._topoConf.get("topology.classpath")));
        return CPJ.join(workercp);
    }

    private String substituteChildOptsInternal(String string, int memOnheap) {
        if (StringUtils.isNotBlank((String)string)) {
            String p = String.valueOf(this._port);
            string = string.replace("%ID%", p);
            string = string.replace("%WORKER-ID%", this._workerId);
            string = string.replace("%TOPOLOGY-ID%", this._topologyId);
            string = string.replace("%WORKER-PORT%", p);
            if (memOnheap > 0) {
                string = string.replace("%HEAP-MEM%", String.valueOf(memOnheap));
            }
            if (this.memoryLimitMB > 0L) {
                string = string.replace("%LIMIT-MEM%", String.valueOf(this.memoryLimitMB));
            }
        }
        return string;
    }

    protected List<String> substituteChildopts(Object value) {
        return this.substituteChildopts(value, -1);
    }

    protected List<String> substituteChildopts(Object value, int memOnheap) {
        ArrayList<String> rets;
        block4: {
            block3: {
                String[] strings;
                rets = new ArrayList<String>();
                if (!(value instanceof String)) break block3;
                String string = this.substituteChildOptsInternal((String)value, memOnheap);
                if (!StringUtils.isNotBlank((String)string)) break block4;
                for (String s : strings = string.split("\\s+")) {
                    if (!StringUtils.isNotBlank((String)s)) continue;
                    rets.add(s);
                }
                break block4;
            }
            if (value instanceof List) {
                List objects = (List)value;
                for (String object : objects) {
                    String str = this.substituteChildOptsInternal(object, memOnheap);
                    if (!StringUtils.isNotBlank((String)str)) continue;
                    rets.add(str);
                }
            }
        }
        return rets;
    }

    protected void launchWorkerProcess(List<String> command, Map<String, String> env, String logPrefix, ExitCodeCallback processExitCallback, File targetDir) throws IOException {
        if (this._resourceIsolationManager != null) {
            command = this._resourceIsolationManager.getLaunchCommand(this._workerId, command);
        }
        ClientSupervisorUtils.launchProcess(command, env, (String)logPrefix, (ExitCodeCallback)processExitCallback, (File)targetDir);
    }

    private String getWorkerLoggingConfigFile() {
        String log4jConfigurationDir = (String)this._conf.get("storm.log4j2.conf.dir");
        if (StringUtils.isNotBlank((String)log4jConfigurationDir)) {
            if (!ServerUtils.isAbsolutePath(log4jConfigurationDir)) {
                log4jConfigurationDir = this._stormHome + File.separator + log4jConfigurationDir;
            }
        } else {
            log4jConfigurationDir = this._stormHome + File.separator + "log4j2";
        }
        if (ServerUtils.IS_ON_WINDOWS && !log4jConfigurationDir.startsWith("file:")) {
            log4jConfigurationDir = "file:///" + log4jConfigurationDir;
        }
        return log4jConfigurationDir + File.separator + "worker.xml";
    }

    private List<String> getClassPathParams(String stormRoot, SimpleVersion topoVersion) throws IOException {
        String stormJar = ConfigUtils.supervisorStormJarPath((String)stormRoot);
        List<String> dependencyLocations = BasicContainer.getDependencyLocationsFor(this._conf, this._topologyId, this._ops, stormRoot);
        String workerClassPath = this.getWorkerClassPath(stormJar, dependencyLocations, topoVersion);
        ArrayList<String> classPathParams = new ArrayList<String>();
        classPathParams.add("-cp");
        classPathParams.add(workerClassPath);
        return classPathParams;
    }

    private List<String> getCommonParams() {
        String workersArtifacts = ConfigUtils.workerArtifactsRoot((Map)this._conf);
        String stormLogDir = ConfigUtils.getLogDir();
        ArrayList<String> commonParams = new ArrayList<String>();
        commonParams.add("-Dlogging.sensitivity=" + (String)Utils.OR((Object)((String)this._topoConf.get("topology.logging.sensitivity")), (Object)"S3"));
        commonParams.add("-Dlogfile.name=worker.log");
        commonParams.add("-Dstorm.home=" + (String)Utils.OR((Object)this._stormHome, (Object)""));
        commonParams.add("-Dworkers.artifacts=" + workersArtifacts);
        commonParams.add("-Dstorm.id=" + this._topologyId);
        commonParams.add("-Dworker.id=" + this._workerId);
        commonParams.add("-Dworker.port=" + this._port);
        commonParams.add("-Dstorm.log.dir=" + stormLogDir);
        commonParams.add("-DLog4jContextSelector=org.apache.logging.log4j.core.selector.BasicContextSelector");
        commonParams.add("-Dstorm.local.dir=" + this._conf.get("storm.local.dir"));
        if (this.memoryLimitMB > 0L) {
            commonParams.add("-Dworker.memory_limit_mb=" + this.memoryLimitMB);
        }
        return commonParams;
    }

    private int getMemOnHeap(WorkerResources resources) {
        int memOnheap = 0;
        memOnheap = resources != null && resources.is_set_mem_on_heap() && resources.get_mem_on_heap() > 0.0 ? (int)Math.ceil(resources.get_mem_on_heap()) : ObjectReader.getInt(this._topoConf.get("worker.heap.memory.mb"), (Integer)768);
        return memOnheap;
    }

    private List<String> getWorkerProfilerChildOpts(int memOnheap) {
        List<String> workerProfilerChildopts = new ArrayList<String>();
        if (ObjectReader.getBoolean(this._conf.get("worker.profiler.enabled"), (boolean)false)) {
            workerProfilerChildopts = this.substituteChildopts(this._conf.get("worker.profiler.childopts"), memOnheap);
        }
        return workerProfilerChildopts;
    }

    protected String javaCmd(String cmd) {
        String ret = null;
        String javaHome = System.getenv().get("JAVA_HOME");
        ret = StringUtils.isNotBlank((String)javaHome) ? javaHome + File.separator + "bin" + File.separator + cmd : cmd;
        return ret;
    }

    private List<String> mkLaunchCommand(int memOnheap, String stormRoot, String jlp) throws IOException {
        String log4jConfigurationFile;
        String javaCmd = this.javaCmd("java");
        String stormOptions = ConfigUtils.concatIfNotNull((String)System.getProperty("storm.options"));
        String topoConfFile = ConfigUtils.concatIfNotNull((String)System.getProperty("storm.conf.file"));
        String workerTmpDir = ConfigUtils.workerTmpRoot((Map)this._conf, (String)this._workerId);
        String topoVersionString = BasicContainer.getStormVersionFor(this._conf, this._topologyId, this._ops, stormRoot);
        if (topoVersionString == null) {
            topoVersionString = this._conf.getOrDefault("supervisor.worker.default.version", VersionInfo.getVersion());
        }
        SimpleVersion topoVersion = new SimpleVersion(topoVersionString);
        List<String> classPathParams = this.getClassPathParams(stormRoot, topoVersion);
        List<String> commonParams = this.getCommonParams();
        String workerLog4jConfig = log4jConfigurationFile = this.getWorkerLoggingConfigFile();
        if (this._topoConf.get("topology.logging.config") != null) {
            workerLog4jConfig = workerLog4jConfig + "," + this._topoConf.get("topology.logging.config");
        }
        ArrayList<String> commandList = new ArrayList<String>();
        String logWriter = this.getWorkerLogWriter(topoVersion);
        if (logWriter != null) {
            commandList.add(javaCmd);
            commandList.addAll(classPathParams);
            commandList.addAll(this.substituteChildopts(this._topoConf.get("topology.worker.logwriter.childopts")));
            commandList.addAll(commonParams);
            commandList.add("-Dlog4j.configurationFile=" + log4jConfigurationFile);
            commandList.add(logWriter);
        }
        commandList.add(javaCmd);
        commandList.add("-server");
        commandList.addAll(commonParams);
        commandList.add("-Dlog4j.configurationFile=" + workerLog4jConfig);
        commandList.addAll(this.substituteChildopts(this._conf.get("worker.childopts"), memOnheap));
        commandList.addAll(this.substituteChildopts(this._topoConf.get("topology.worker.childopts"), memOnheap));
        commandList.addAll(this.substituteChildopts(Utils.OR(this._topoConf.get("topology.worker.gc.childopts"), this._conf.get("worker.gc.childopts")), memOnheap));
        commandList.addAll(this.getWorkerProfilerChildOpts(memOnheap));
        commandList.add("-Djava.library.path=" + jlp);
        commandList.add("-Dstorm.conf.file=" + topoConfFile);
        commandList.add("-Dstorm.options=" + stormOptions);
        commandList.add("-Djava.io.tmpdir=" + workerTmpDir);
        commandList.addAll(classPathParams);
        commandList.add(this.getWorkerMain(topoVersion));
        commandList.add(this._topologyId);
        commandList.add(this._supervisorId);
        if (topoVersion.getMajor() == -1 && topoVersion.getMinor() == -1 || topoVersion.compareTo(Nimbus.MIN_VERSION_SUPPORT_RPC_HEARTBEAT) >= 0) {
            commandList.add(String.valueOf(this._supervisorPort));
        }
        commandList.add(String.valueOf(this._port));
        commandList.add(this._workerId);
        return commandList;
    }

    @Override
    public boolean isMemoryLimitViolated(LocalAssignment withUpdatedLimits) throws IOException {
        if (super.isMemoryLimitViolated(withUpdatedLimits)) {
            return true;
        }
        if (this._resourceIsolationManager != null) {
            String typeOfCheck;
            long hardMemoryLimitOver;
            long memoryLimitMb;
            long usageMb;
            if (withUpdatedLimits.is_set_total_node_shared()) {
                usageMb = this.getTotalTopologyMemoryUsed();
                memoryLimitMb = this.getTotalTopologyMemoryReserved(withUpdatedLimits);
                hardMemoryLimitOver = this.hardMemoryLimitOver * this.getTotalWorkersForThisTopology();
                typeOfCheck = "TOPOLOGY " + this._topologyId;
            } else {
                usageMb = this.getMemoryUsageMb();
                memoryLimitMb = this.memoryLimitMB;
                hardMemoryLimitOver = this.hardMemoryLimitOver;
                typeOfCheck = "WORKER " + this._workerId;
            }
            LOG.debug("Enforcing memory usage for {} with usage of {} out of {} total and a hard limit of {}", new Object[]{typeOfCheck, usageMb, memoryLimitMb, hardMemoryLimitOver});
            if (usageMb <= 0L) {
                return false;
            }
            long hardLimitMb = Math.max((long)((double)memoryLimitMb * this.hardMemoryLimitMultiplier), memoryLimitMb + hardMemoryLimitOver);
            if (usageMb > hardLimitMb) {
                LOG.warn("{} is using {} MB > adjusted hard limit {} MB", new Object[]{typeOfCheck, usageMb, hardLimitMb});
                return true;
            }
            if (usageMb > memoryLimitMb) {
                long systemFreeMemoryMb = 0L;
                try {
                    systemFreeMemoryMb = this._resourceIsolationManager.getSystemFreeMemoryMb();
                }
                catch (IOException e) {
                    LOG.warn("Error trying to calculate free memory on the system {}", (Throwable)e);
                }
                LOG.debug("SYSTEM MEMORY FREE {} MB", (Object)systemFreeMemoryMb);
                if (systemFreeMemoryMb <= this.lowMemoryThresholdMB) {
                    LOG.warn("{} is using {} MB > memory limit {} MB and system is low on memory {} free", new Object[]{typeOfCheck, usageMb, memoryLimitMb, systemFreeMemoryMb});
                    return true;
                }
                if (systemFreeMemoryMb < this.mediumMemoryThresholdMb) {
                    if (this.memoryLimitExceededStart < 0L) {
                        this.memoryLimitExceededStart = Time.currentTimeMillis();
                    } else {
                        long timeInViolation = Time.currentTimeMillis() - this.memoryLimitExceededStart;
                        if (timeInViolation > this.mediumMemoryGracePeriodMs) {
                            LOG.warn("{} is using {} MB > memory limit {} MB for {} seconds", new Object[]{typeOfCheck, usageMb, memoryLimitMb, timeInViolation / 1000L});
                            return true;
                        }
                    }
                } else {
                    LOG.debug("{} is using {} MB > memory limit {} MB", new Object[]{typeOfCheck, usageMb, memoryLimitMb});
                    this.memoryLimitExceededStart = -1L;
                }
            } else {
                this.memoryLimitExceededStart = -1L;
            }
        }
        return false;
    }

    @Override
    public long getMemoryUsageMb() {
        try {
            long usageBytes;
            long ret = 0L;
            if (this._resourceIsolationManager != null && (usageBytes = this._resourceIsolationManager.getMemoryUsage(this._workerId)) >= 0L) {
                ret = usageBytes / 1024L / 1024L;
            }
            return ret;
        }
        catch (IOException e) {
            LOG.warn("Error trying to calculate worker memory usage {}", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long getMemoryReservationMb() {
        return this.memoryLimitMB;
    }

    private long calculateMemoryLimit(WorkerResources resources, int memOnHeap) {
        long ret = memOnHeap;
        if (this._resourceIsolationManager != null) {
            int memoffheap = (int)Math.ceil(resources.get_mem_off_heap());
            int extraMem = (int)Math.ceil(ObjectReader.getDouble(this._conf.get(DaemonConfig.STORM_SUPERVISOR_MEMORY_LIMIT_TOLERANCE_MARGIN_MB), (Double)0.0));
            ret += (long)(memoffheap + extraMem);
        }
        return ret;
    }

    @Override
    public void launch() throws IOException {
        String ld_library_path;
        this._type.assertFull();
        LOG.info("Launching worker with assignment {} for this supervisor {} on port {} with id {}", new Object[]{this._assignment, this._supervisorId, this._port, this._workerId});
        String logPrefix = "Worker Process " + this._workerId;
        ProcessExitCallback processExitCallback = new ProcessExitCallback(logPrefix);
        this._exitedEarly = false;
        WorkerResources resources = this._assignment.get_resources();
        int memOnHeap = this.getMemOnHeap(resources);
        this.memoryLimitMB = this.calculateMemoryLimit(resources, memOnHeap);
        String stormRoot = ConfigUtils.supervisorStormDistRoot((Map)this._conf, (String)this._topologyId);
        String jlp = this.javaLibraryPath(stormRoot, this._conf);
        HashMap<String, String> topEnvironment = new HashMap<String, String>();
        Map environment = (Map)this._topoConf.get("topology.environment");
        if (environment != null) {
            topEnvironment.putAll(environment);
        }
        if ((ld_library_path = (String)topEnvironment.get("LD_LIBRARY_PATH")) != null) {
            jlp = jlp + System.getProperty("path.separator") + ld_library_path;
        }
        topEnvironment.put("LD_LIBRARY_PATH", jlp);
        if (this._resourceIsolationManager != null) {
            int cpu = (int)Math.ceil(resources.get_cpu());
            this._resourceIsolationManager.reserveResourcesForWorker(this._workerId, (int)this.memoryLimitMB, cpu);
        }
        List<String> commandList = this.mkLaunchCommand(memOnHeap, stormRoot, jlp);
        LOG.info("Launching worker with command: {}. ", (Object)ServerUtils.shellCmd(commandList));
        String workerDir = ConfigUtils.workerRoot((Map)this._conf, (String)this._workerId);
        this.launchWorkerProcess(commandList, topEnvironment, logPrefix, processExitCallback, new File(workerDir));
    }

    private class ProcessExitCallback
    implements ExitCodeCallback {
        private final String _logPrefix;

        public ProcessExitCallback(String logPrefix) {
            this._logPrefix = logPrefix;
        }

        public void call(int exitCode) {
            LOG.info("{} exited with code: {}", (Object)this._logPrefix, (Object)exitCode);
            BasicContainer.this._exitedEarly = true;
        }
    }

    static class TopoMetaLRUCache {
        public final int _maxSize = 100;
        private LinkedHashMap<String, TopologyMetaData> _cache = new LinkedHashMap<String, TopologyMetaData>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TopologyMetaData> eldest) {
                return this.size() > 100;
            }
        };

        TopoMetaLRUCache() {
        }

        public synchronized TopologyMetaData get(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) {
            TopologyMetaData dl = this._cache.get(topologyId);
            if (dl == null) {
                this._cache.putIfAbsent(topologyId, new TopologyMetaData(conf, topologyId, ops, stormRoot));
                dl = this._cache.get(topologyId);
            }
            return dl;
        }

        public synchronized void clear() {
            this._cache.clear();
        }
    }

    private static class TopologyMetaData {
        private final Map<String, Object> _conf;
        private final String _topologyId;
        private final AdvancedFSOps _ops;
        private final String _stormRoot;
        private boolean _dataCached = false;
        private List<String> _depLocs = null;
        private String _stormVersion = null;

        public TopologyMetaData(Map<String, Object> conf, String topologyId, AdvancedFSOps ops, String stormRoot) {
            this._conf = conf;
            this._topologyId = topologyId;
            this._ops = ops;
            this._stormRoot = stormRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String stormVersion;
            List<String> data;
            TopologyMetaData topologyMetaData = this;
            synchronized (topologyMetaData) {
                data = this._depLocs;
                stormVersion = this._stormVersion;
            }
            return "META for " + this._topologyId + " DEP_LOCS => " + data + " STORM_VERSION => " + stormVersion;
        }

        private synchronized void readData() throws IOException {
            StormTopology stormTopology = ConfigUtils.readSupervisorTopology(this._conf, (String)this._topologyId, (AdvancedFSOps)this._ops);
            ArrayList<String> dependencyLocations = new ArrayList<String>();
            if (stormTopology.get_dependency_jars() != null) {
                for (String dependency : stormTopology.get_dependency_jars()) {
                    dependencyLocations.add(new File(this._stormRoot, dependency).getAbsolutePath());
                }
            }
            if (stormTopology.get_dependency_artifacts() != null) {
                for (String dependency : stormTopology.get_dependency_artifacts()) {
                    dependencyLocations.add(new File(this._stormRoot, dependency).getAbsolutePath());
                }
            }
            this._depLocs = dependencyLocations;
            this._stormVersion = stormTopology.get_storm_version();
            this._dataCached = true;
        }

        public synchronized List<String> getDepLocs() throws IOException {
            if (!this._dataCached) {
                this.readData();
            }
            return this._depLocs;
        }

        public synchronized String getStormVersion() throws IOException {
            if (!this._dataCached) {
                this.readData();
            }
            return this._stormVersion;
        }
    }
}

