/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerLauncher;
import org.apache.storm.daemon.supervisor.ContainerMemoryTracker;
import org.apache.storm.daemon.supervisor.Killable;
import org.apache.storm.daemon.supervisor.RunAsUserContainer;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.LocalState;

public class RunAsUserContainerLauncher
extends ContainerLauncher {
    protected final ResourceIsolationInterface _resourceIsolationManager;
    private final Map<String, Object> _conf;
    private final String _supervisorId;
    private final int _supervisorPort;
    private final StormMetricsRegistry metricsRegistry;
    private final ContainerMemoryTracker containerMemoryTracker;

    public RunAsUserContainerLauncher(Map<String, Object> conf, String supervisorId, int supervisorPort, ResourceIsolationInterface resourceIsolationManager, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker) throws IOException {
        this._conf = conf;
        this._supervisorId = supervisorId;
        this._supervisorPort = supervisorPort;
        this._resourceIsolationManager = resourceIsolationManager;
        this.metricsRegistry = metricsRegistry;
        this.containerMemoryTracker = containerMemoryTracker;
    }

    @Override
    public Container launchContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        RunAsUserContainer container = new RunAsUserContainer(Container.ContainerType.LAUNCH, this._conf, this._supervisorId, this._supervisorPort, port, assignment, this._resourceIsolationManager, state, null, this.metricsRegistry, this.containerMemoryTracker, null, null, null);
        container.setup();
        ((Container)container).launch();
        return container;
    }

    @Override
    public Container recoverContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        return new RunAsUserContainer(Container.ContainerType.RECOVER_FULL, this._conf, this._supervisorId, this._supervisorPort, port, assignment, this._resourceIsolationManager, state, null, this.metricsRegistry, this.containerMemoryTracker, null, null, null);
    }

    @Override
    public Killable recoverContainer(String workerId, LocalState localState) throws IOException {
        return new RunAsUserContainer(Container.ContainerType.RECOVER_PARTIAL, this._conf, this._supervisorId, this._supervisorPort, -1, null, this._resourceIsolationManager, localState, workerId, this.metricsRegistry, this.containerMemoryTracker, null, null, null);
    }
}

