/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.Collections;
import java.util.Map;
import org.apache.storm.daemon.supervisor.Slot;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.EnumUtil;

class SlotMetrics {
    final Meter numWorkersLaunched;
    final Map<Slot.KillReason, Meter> numWorkersKilledFor;
    final Timer workerLaunchDuration;
    final Map<Slot.MachineState, Meter> transitionIntoState;
    final Map<Slot.MachineState, Timer> timeSpentInState;

    SlotMetrics(StormMetricsRegistry metricsRegistry) {
        this.numWorkersLaunched = metricsRegistry.registerMeter("supervisor:num-workers-launched");
        this.numWorkersKilledFor = Collections.unmodifiableMap(EnumUtil.toEnumMap(Slot.KillReason.class, killReason -> metricsRegistry.registerMeter("supervisor:num-workers-killed-" + killReason.toString())));
        this.workerLaunchDuration = metricsRegistry.registerTimer("supervisor:worker-launch-duration");
        this.transitionIntoState = Collections.unmodifiableMap(EnumUtil.toEnumMap(Slot.MachineState.class, machineState -> metricsRegistry.registerMeter("supervisor:num-worker-transitions-into-" + machineState.toString())));
        this.timeSpentInState = Collections.unmodifiableMap(EnumUtil.toEnumMap(Slot.MachineState.class, machineState -> metricsRegistry.registerTimer("supervisor:time-worker-spent-in-state-" + machineState.toString() + "-ms")));
    }
}

