/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.healthcheck;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecker {
    private static final Logger LOG = LoggerFactory.getLogger(HealthChecker.class);
    private static final String FAILED = "failed";
    private static final String SUCCESS = "success";
    private static final String TIMEOUT = "timeout";
    private static final String FAILED_WITH_EXIT_CODE = "failed_with_exit_code";

    public static int healthCheck(Map<String, Object> conf) {
        String healthDir = ServerConfigUtils.absoluteHealthCheckDir(conf);
        ArrayList<String> results = new ArrayList<String>();
        if (healthDir != null) {
            File parentFile = new File(healthDir);
            ArrayList<String> healthScripts = new ArrayList<String>();
            if (parentFile.exists()) {
                File[] list;
                for (File f : list = parentFile.listFiles()) {
                    if (f.isDirectory() || !f.canExecute()) continue;
                    healthScripts.add(f.getAbsolutePath());
                }
            }
            for (String script : healthScripts) {
                String result = HealthChecker.processScript(conf, script);
                results.add(result);
                LOG.info("The healthcheck script [ {} ] exited with status: {}", (Object)script, (Object)result);
            }
        }
        if (results.contains(FAILED) || results.contains(FAILED_WITH_EXIT_CODE) || results.contains(TIMEOUT)) {
            LOG.warn("The supervisor healthchecks failed!!!");
            return 1;
        }
        LOG.info("The supervisor healthchecks succeeded.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processScript(Map<String, Object> conf, String script) {
        Thread interruptThread = null;
        try {
            Process process = Runtime.getRuntime().exec(script);
            final long timeout = ObjectReader.getLong((Object)conf.get("storm.health.check.timeout.ms"), (Long)5000L);
            final Thread curThread = Thread.currentThread();
            interruptThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(timeout);
                        curThread.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            interruptThread.start();
            process.waitFor();
            interruptThread.interrupt();
            curThread.interrupted();
            if (process.exitValue() != 0) {
                String str;
                InputStream stdin = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stdin));
                while ((str = reader.readLine()) != null) {
                    if (!str.startsWith("ERROR")) continue;
                    LOG.warn("The healthcheck process {} exited with code {}", (Object)script, (Object)process.exitValue());
                    String string = FAILED;
                    return string;
                }
                String string = FAILED_WITH_EXIT_CODE;
                return string;
            }
            String string = SUCCESS;
            return string;
        }
        catch (InterruptedException | ClosedByInterruptException e) {
            LOG.warn("Script:  {} timed out.", (Object)script);
            String string = TIMEOUT;
            return string;
        }
        catch (Exception e) {
            LOG.warn("Script failed with exception: ", (Throwable)e);
            String string = FAILED;
            return string;
        }
        finally {
            if (interruptThread != null) {
                interruptThread.interrupt();
            }
        }
    }
}

