/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.storm.generated.ComponentType;
import org.apache.storm.scheduler.ExecutorDetails;

public class Component {
    private final String id;
    private final List<ExecutorDetails> execs;
    private final ComponentType type;
    private final Set<String> parents = new HashSet<String>();
    private final Set<String> children = new HashSet<String>();

    public Component(ComponentType type, String compId, List<ExecutorDetails> execs) {
        this.type = type;
        this.id = compId;
        this.execs = execs;
    }

    public void addChild(Component child) {
        this.children.add(child.getId());
        child.parents.add(this.id);
    }

    public String getId() {
        return this.id;
    }

    public List<ExecutorDetails> getExecs() {
        return this.execs;
    }

    public ComponentType getType() {
        return this.type;
    }

    public Set<String> getParents() {
        return this.parents;
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public String toString() {
        return "{id: " + this.getId() + " Parents: " + this.getParents() + " Children: " + this.getChildren() + " Execs: " + this.getExecs() + "}";
    }
}

