/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import org.apache.storm.generated.WorkerResources;

public class SupervisorResources {
    private final double totalMem;
    private final double totalCpu;
    private final double usedMem;
    private final double usedCpu;

    public SupervisorResources(double totalMem, double totalCpu, double usedMem, double usedCpu) {
        this.totalMem = totalMem;
        this.totalCpu = totalCpu;
        this.usedMem = usedMem;
        this.usedCpu = usedCpu;
    }

    public double getUsedMem() {
        return this.usedMem;
    }

    public double getUsedCpu() {
        return this.usedCpu;
    }

    public double getTotalMem() {
        return this.totalMem;
    }

    public double getTotalCpu() {
        return this.totalCpu;
    }

    public double getAvailableCpu() {
        return this.totalCpu - this.usedCpu;
    }

    public double getAvailableMem() {
        return this.totalMem - this.usedMem;
    }

    SupervisorResources add(WorkerResources wr) {
        return new SupervisorResources(this.totalMem, this.totalCpu, this.usedMem + wr.get_mem_off_heap() + wr.get_mem_on_heap(), this.usedCpu + wr.get_cpu());
    }

    public SupervisorResources addMem(Double value) {
        return new SupervisorResources(this.totalMem, this.totalCpu, this.usedMem + value, this.usedCpu);
    }
}

