/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.multitenant;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.multitenant.Node;
import org.apache.storm.scheduler.multitenant.NodePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreePool
extends NodePool {
    private static final Logger LOG = LoggerFactory.getLogger(FreePool.class);
    private Set<Node> _nodes = new HashSet<Node>();
    private int _totalSlots = 0;

    @Override
    public void init(Cluster cluster, Map<String, Node> nodeIdToNode) {
        super.init(cluster, nodeIdToNode);
        for (Node n : nodeIdToNode.values()) {
            if (!n.isTotallyFree() || !n.isAlive()) continue;
            this._nodes.add(n);
            this._totalSlots += n.totalSlotsFree();
        }
        LOG.debug("Found {} nodes with {} slots", (Object)this._nodes.size(), (Object)this._totalSlots);
    }

    @Override
    public void addTopology(TopologyDetails td) {
        throw new IllegalArgumentException("The free pool cannot run any topologies");
    }

    @Override
    public boolean canAdd(TopologyDetails td) {
        return false;
    }

    @Override
    public Collection<Node> takeNodes(int nodesNeeded) {
        HashSet<Node> ret = new HashSet<Node>();
        Iterator<Node> it = this._nodes.iterator();
        while (it.hasNext() && nodesNeeded > ret.size()) {
            Node n = it.next();
            ret.add(n);
            this._totalSlots -= n.totalSlotsFree();
            it.remove();
        }
        return ret;
    }

    @Override
    public int nodesAvailable() {
        return this._nodes.size();
    }

    @Override
    public int slotsAvailable() {
        return this._totalSlots;
    }

    @Override
    public Collection<Node> takeNodesBySlots(int slotsNeeded) {
        HashSet<Node> ret = new HashSet<Node>();
        Iterator<Node> it = this._nodes.iterator();
        while (it.hasNext() && slotsNeeded > 0) {
            Node n = it.next();
            ret.add(n);
            this._totalSlots -= n.totalSlotsFree();
            slotsNeeded -= n.totalSlotsFree();
            it.remove();
        }
        return ret;
    }

    @Override
    public NodePool.NodeAndSlotCounts getNodeAndSlotCountIfSlotsWereTaken(int slotsNeeded) {
        int slotsFound = 0;
        int nodesFound = 0;
        Iterator<Node> it = this._nodes.iterator();
        while (it.hasNext() && slotsNeeded > 0) {
            Node n = it.next();
            ++nodesFound;
            int totalSlots = n.totalSlots();
            slotsFound += totalSlots;
            slotsNeeded -= totalSlots;
        }
        return new NodePool.NodeAndSlotCounts(nodesFound, slotsFound);
    }

    @Override
    public void scheduleAsNeeded(NodePool ... lesserPools) {
    }

    public String toString() {
        return "FreePool of " + this._nodes.size() + " nodes with " + this._totalSlots + " slots";
    }
}

