/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.utils;

import java.net.URI;
import java.util.Map;
import org.apache.storm.scheduler.utils.ArtifactoryConfigLoader;
import org.apache.storm.scheduler.utils.IConfigLoader;
import org.apache.storm.scheduler.utils.IConfigLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactoryConfigLoaderFactory
implements IConfigLoaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactoryConfigLoaderFactory.class);

    @Override
    public IConfigLoader createIfSupported(URI uri, Map<String, Object> conf) {
        String scheme = uri.getScheme();
        if ("artifactory+http".equalsIgnoreCase(scheme) || "artifactory+https".equalsIgnoreCase(scheme)) {
            return new ArtifactoryConfigLoader(conf);
        }
        LOG.debug("scheme {} not supported in this factory.", (Object)scheme);
        return null;
    }
}

