/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.auth.Subject;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.blobstore.LocalFsBlobStore;
import org.apache.storm.blobstore.LocalModeClientBlobStore;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AccessControlType;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.scheduler.resource.ResourceUtils;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.ShellUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ServerUtils.class);
    public static final boolean IS_ON_WINDOWS = "Windows_NT".equals(System.getenv("OS"));
    public static final int SIGKILL = 9;
    public static final int SIGTERM = 15;
    private static ServerUtils _instance = new ServerUtils();

    public static ServerUtils setInstance(ServerUtils u) {
        ServerUtils oldInstance = _instance;
        _instance = u;
        return oldInstance;
    }

    public static <T> List<T> interleaveAll(List<List<T>> nodeList) {
        if (nodeList != null && nodeList.size() > 0) {
            ArrayList<T> first = new ArrayList<T>();
            ArrayList<List<T>> rest = new ArrayList<List<T>>();
            for (List<T> node : nodeList) {
                if (node == null || node.size() <= 0) continue;
                first.add(node.get(0));
                rest.add(node.subList(1, node.size()));
            }
            List<T> interleaveRest = ServerUtils.interleaveAll(rest);
            if (interleaveRest != null) {
                first.addAll(interleaveRest);
            }
            return first;
        }
        return null;
    }

    public static BlobStore getNimbusBlobStore(Map<String, Object> conf, NimbusInfo nimbusInfo, ILeaderElector leaderElector) {
        return ServerUtils.getNimbusBlobStore(conf, null, nimbusInfo, leaderElector);
    }

    public static BlobStore getNimbusBlobStore(Map<String, Object> conf, String baseDir, NimbusInfo nimbusInfo, ILeaderElector leaderElector) {
        String type = (String)conf.get("nimbus.blobstore.class");
        if (type == null) {
            type = LocalFsBlobStore.class.getName();
        }
        BlobStore store = (BlobStore)ReflectionUtils.newInstance((String)type);
        HashMap<String, Object> nconf = new HashMap<String, Object>(conf);
        nconf.put("blobstore.cleanup.enable", Boolean.TRUE);
        if (store != null) {
            store.prepare(nconf, baseDir, nimbusInfo, leaderElector);
        }
        return store;
    }

    public static boolean isAbsolutePath(String path) {
        return Paths.get(path, new String[0]).isAbsolute();
    }

    public static String shellCmd(List<String> command) {
        ArrayList<String> changedCommands = new ArrayList<String>(command.size());
        for (String str : command) {
            if (str == null) continue;
            changedCommands.add("'" + str.replaceAll("'", "'\"'\"'") + "'");
        }
        return StringUtils.join(changedCommands, (String)" ");
    }

    public static long getDU(File dir) {
        long size = 0L;
        if (!dir.exists()) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return dir.length();
        }
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (int i = 0; i < allFiles.length; ++i) {
                boolean isSymLink;
                try {
                    isSymLink = FileUtils.isSymlink((File)allFiles[i]);
                }
                catch (IOException ioe) {
                    isSymLink = true;
                }
                if (isSymLink) continue;
                size += ServerUtils.getDU(allFiles[i]);
            }
        }
        return size;
    }

    public static ClientBlobStore getClientBlobStoreForSupervisor(Map<String, Object> conf) {
        Object store = ConfigUtils.isLocalMode(conf) ? new LocalModeClientBlobStore(ServerUtils.getNimbusBlobStore(conf, null, null)) : (ClientBlobStore)ReflectionUtils.newInstance((String)((String)conf.get("supervisor.blobstore.class")));
        store.prepare(conf);
        return store;
    }

    public static void downloadResourcesAsSupervisor(String key, String localFile, ClientBlobStore cb) throws AuthorizationException, KeyNotFoundException, IOException {
        _instance.downloadResourcesAsSupervisorImpl(key, localFile, cb);
    }

    public static String currentClasspath() {
        return _instance.currentClasspathImpl();
    }

    public static boolean zipDoesContainDir(String zipfile, String target) throws IOException {
        ArrayList<? extends ZipEntry> entries = Collections.list(new ZipFile(zipfile).entries());
        String targetDir = target + "/";
        for (ZipEntry zipEntry : entries) {
            String name = zipEntry.getName();
            if (!name.startsWith(targetDir)) continue;
            return true;
        }
        return false;
    }

    public static String getFileOwner(String path) throws IOException {
        return Files.getOwner(FileSystems.getDefault().getPath(path, new String[0]), new LinkOption[0]).getName();
    }

    public static String containerFilePath(String dir) {
        return dir + File.separator + "launch_container.sh";
    }

    public static String scriptFilePath(String dir) {
        return dir + File.separator + "storm-worker-script.sh";
    }

    public static String writeScript(String dir, List<String> command, Map<String, String> environment) throws IOException {
        String path = ServerUtils.scriptFilePath(dir);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(path));){
            out.write("#!/bin/bash");
            out.newLine();
            if (environment != null) {
                for (String k : environment.keySet()) {
                    String v = environment.get(k);
                    if (v == null) {
                        v = "";
                    }
                    out.write(ServerUtils.shellCmd(Arrays.asList("export", k + "=" + v)));
                    out.write(";");
                    out.newLine();
                }
            }
            out.newLine();
            out.write("exec " + ServerUtils.shellCmd(command) + ";");
        }
        return path;
    }

    public static int execCommand(String ... command) throws ExecuteException, IOException {
        CommandLine cmd = new CommandLine(command[0]);
        for (int i = 1; i < command.length; ++i) {
            cmd.addArgument(command[i]);
        }
        DefaultExecutor exec = new DefaultExecutor();
        return exec.execute(cmd);
    }

    public static void sendSignalToProcess(long lpid, int signum) throws IOException {
        String pid = Long.toString(lpid);
        try {
            if (Utils.isOnWindows()) {
                if (signum == 9) {
                    ServerUtils.execCommand("taskkill", "/f", "/pid", pid);
                } else {
                    ServerUtils.execCommand("taskkill", "/pid", pid);
                }
            } else {
                ServerUtils.execCommand("kill", "-" + signum, pid);
            }
        }
        catch (ExecuteException e) {
            LOG.info("Error when trying to kill {}. Process is probably already dead.", (Object)pid);
        }
        catch (IOException e) {
            LOG.info("IOException Error when trying to kill {}.", (Object)pid);
            throw e;
        }
    }

    public static void killProcessWithSigTerm(String pid) throws IOException {
        ServerUtils.sendSignalToProcess(Long.parseLong(pid), 15);
    }

    public static void forceKillProcess(String pid) throws IOException {
        ServerUtils.sendSignalToProcess(Long.parseLong(pid), 9);
    }

    public static long nimbusVersionOfBlob(String key, ClientBlobStore cb) throws AuthorizationException, KeyNotFoundException {
        long nimbusBlobVersion = 0L;
        ReadableBlobMeta metadata = cb.getBlobMeta(key);
        nimbusBlobVersion = metadata.get_version();
        return nimbusBlobVersion;
    }

    public static boolean canUserReadBlob(ReadableBlobMeta meta, String user, Map<String, Object> conf) {
        if (!ObjectReader.getBoolean((Object)conf.get("storm.blobstore.acl.validation.enabled"), (boolean)false)) {
            return true;
        }
        SettableBlobMeta settable = meta.get_settable();
        for (AccessControl acl : settable.get_acl()) {
            if (acl.get_type().equals((Object)AccessControlType.OTHER) && (acl.get_access() & 1) > 0) {
                return true;
            }
            if (!acl.get_name().equals(user) || (acl.get_access() & 1) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void unJar(File jarFile, File toDir) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            ServerUtils.extractZipFile(jar, toDir, null);
        }
    }

    private static void ensureDirectory(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + dir.toString());
        }
    }

    public static void unTar(File inFile, File untarDir, boolean symlinksDisabled) throws IOException {
        ServerUtils.ensureDirectory(untarDir);
        boolean gzipped = inFile.toString().endsWith("gz");
        if (Utils.isOnWindows() || symlinksDisabled) {
            ServerUtils.unTarUsingJava(inFile, untarDir, gzipped, symlinksDisabled);
        } else {
            ServerUtils.unTarUsingTar(inFile, untarDir, gzipped);
        }
    }

    private static void unTarUsingTar(File inFile, File untarDir, boolean gzipped) throws IOException {
        StringBuffer untarCommand = new StringBuffer();
        if (gzipped) {
            untarCommand.append(" gzip -dc '");
            untarCommand.append(inFile.toString());
            untarCommand.append("' | (");
        }
        untarCommand.append("cd '");
        untarCommand.append(untarDir.toString());
        untarCommand.append("' ; ");
        untarCommand.append("tar -xf ");
        if (gzipped) {
            untarCommand.append(" -)");
        } else {
            untarCommand.append(inFile.toString());
        }
        String[] shellCmd = new String[]{"bash", "-c", untarCommand.toString()};
        ShellUtils.ShellCommandExecutor shexec = new ShellUtils.ShellCommandExecutor(shellCmd);
        shexec.execute();
        int exitcode = shexec.getExitCode();
        if (exitcode != 0) {
            throw new IOException("Error untarring file " + inFile + ". Tar process exited with exit code " + exitcode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unTarUsingJava(File inFile, File untarDir, boolean gzipped, boolean symlinksDisabled) throws IOException {
        String base = untarDir.getCanonicalPath();
        LOG.trace("java untar {} to {}", (Object)inFile, (Object)base);
        try (InputStream inputStream = null;){
            inputStream = gzipped ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(inFile))) : new BufferedInputStream(new FileInputStream(inFile));
            try (TarArchiveInputStream tis = new TarArchiveInputStream(inputStream);){
                TarArchiveEntry entry = tis.getNextTarEntry();
                while (entry != null) {
                    ServerUtils.unpackEntries(tis, entry, untarDir, base, symlinksDisabled);
                    entry = tis.getNextTarEntry();
                }
            }
        }
    }

    private static void unpackEntries(TarArchiveInputStream tis, TarArchiveEntry entry, File outputDir, String base, boolean symlinksDisabled) throws IOException {
        File target = new File(outputDir, entry.getName());
        String found = target.getCanonicalPath();
        if (!found.startsWith(base)) {
            LOG.error("Invalid location {} is outside of {}", (Object)found, (Object)base);
            return;
        }
        if (entry.isDirectory()) {
            LOG.trace("Extracting dir {}", (Object)target);
            ServerUtils.ensureDirectory(target);
            for (TarArchiveEntry e : entry.getDirectoryEntries()) {
                ServerUtils.unpackEntries(tis, e, target, base, symlinksDisabled);
            }
        } else if (entry.isSymbolicLink()) {
            if (symlinksDisabled) {
                LOG.info("Symlinks disabled skipping {}", (Object)target);
            } else {
                Path src = target.toPath();
                Path dest = Paths.get(entry.getLinkName(), new String[0]);
                LOG.trace("Extracting sym link {} to {}", (Object)target, (Object)dest);
                Files.createSymbolicLink(src, dest, new FileAttribute[0]);
            }
        } else if (entry.isFile()) {
            LOG.trace("Extracting file {}", (Object)target);
            ServerUtils.ensureDirectory(target.getParentFile());
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(target));){
                IOUtils.copy((InputStream)tis, (OutputStream)outputStream);
            }
        } else {
            LOG.error("{} is not a currently supported tar entry type.", (Object)entry);
        }
        Path p = target.toPath();
        if (Files.exists(p, new LinkOption[0])) {
            try {
                int mode = entry.getMode();
                Files.setPosixFilePermissions(p, ServerUtils.parsePerms(mode));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static Set<PosixFilePermission> parsePerms(int mode) {
        HashSet<PosixFilePermission> ret = new HashSet<PosixFilePermission>();
        if ((mode & 1) > 0) {
            ret.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 2) > 0) {
            ret.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 4) > 0) {
            ret.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 8) > 0) {
            ret.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x10) > 0) {
            ret.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 0x20) > 0) {
            ret.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x40) > 0) {
            ret.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x80) > 0) {
            ret.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x100) > 0) {
            ret.add(PosixFilePermission.OWNER_READ);
        }
        return ret;
    }

    public static void unpack(File localrsrc, File dst, boolean symLinksDisabled) throws IOException {
        String lowerDst = localrsrc.getName().toLowerCase();
        if (lowerDst.endsWith(".jar") || lowerDst.endsWith("_jar")) {
            ServerUtils.unJar(localrsrc, dst);
        } else if (lowerDst.endsWith(".zip") || lowerDst.endsWith("_zip")) {
            ServerUtils.unZip(localrsrc, dst);
        } else if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith("_tar_gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith("_tgz") || lowerDst.endsWith(".tar") || lowerDst.endsWith("_tar")) {
            ServerUtils.unTar(localrsrc, dst, symLinksDisabled);
        } else {
            LOG.warn("Cannot unpack " + localrsrc);
            if (!localrsrc.renameTo(dst)) {
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
        }
        if (localrsrc.isFile()) {
            localrsrc.delete();
        }
    }

    public static void extractZipFile(ZipFile zipFile, File toDir, String prefix) throws IOException {
        ServerUtils.ensureDirectory(toDir);
        String base = toDir.getCanonicalPath();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || prefix != null && !entry.getName().startsWith(prefix)) continue;
            if (prefix != null) {
                entryName = entry.getName().substring(prefix.length());
                LOG.debug("Extracting {} shortened to {} into {}", new Object[]{entry.getName(), entryName, toDir});
            } else {
                entryName = entry.getName();
            }
            File file = new File(toDir, entryName);
            String found = file.getCanonicalPath();
            if (!found.startsWith(base)) {
                LOG.error("Invalid location {} is outside of {}", (Object)found, (Object)base);
                continue;
            }
            InputStream in = zipFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                ServerUtils.ensureDirectory(file.getParentFile());
                FileOutputStream out = new FileOutputStream(file);
                Throwable throwable2 = null;
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    public static void unZip(File inFile, File toDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(inFile);){
            ServerUtils.extractZipFile(zipFile, toDir, null);
        }
    }

    public static long zipFileSize(File myFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(myFile, "r");){
            raf.seek(raf.length() - 4L);
            long b4 = raf.read();
            long b3 = raf.read();
            long b2 = raf.read();
            long b1 = raf.read();
            long l = b1 << 24 | (b2 << 16) + (b3 << 8) + b4;
            return l;
        }
    }

    private static boolean downloadResourcesAsSupervisorAttempt(ClientBlobStore cb, String key, String localFile) {
        boolean isSuccess = false;
        try (FileOutputStream out = new FileOutputStream(localFile);
             InputStreamWithMeta in = cb.getBlob(key);){
            int len;
            long fileSize = in.getFileLength();
            byte[] buffer = new byte[1024];
            int downloadFileSize = 0;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
                downloadFileSize += len;
            }
            isSuccess = fileSize == (long)downloadFileSize;
        }
        catch (IOException | TException e) {
            LOG.error("An exception happened while downloading {} from blob store.", (Object)localFile, (Object)e);
        }
        if (!isSuccess) {
            try {
                Files.deleteIfExists(Paths.get(localFile, new String[0]));
            }
            catch (IOException ex) {
                LOG.error("Failed trying to delete the partially downloaded {}", (Object)localFile, (Object)ex);
            }
        }
        return isSuccess;
    }

    public static boolean isRAS(Map<String, Object> conf) {
        return conf.containsKey("storm.scheduler") && conf.get("storm.scheduler").equals("org.apache.storm.scheduler.resource.ResourceAwareScheduler");
    }

    public static int getEstimatedWorkerCountForRASTopo(Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        Double defaultWorkerMaxHeap = ObjectReader.getDouble((Object)topoConf.get("worker.heap.memory.mb"), (Double)768.0);
        Double topologyWorkerMaxHeap = ObjectReader.getDouble((Object)topoConf.get("topology.worker.max.heap.size.mb"), (Double)defaultWorkerMaxHeap);
        return (int)Math.ceil(ServerUtils.getEstimatedTotalHeapMemoryRequiredByTopo(topoConf, topology) / topologyWorkerMaxHeap);
    }

    public static double getEstimatedTotalHeapMemoryRequiredByTopo(Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        double memoryRequirement;
        int parallelism;
        Map<String, Integer> componentParallelism = ServerUtils.getComponentParallelism(topoConf, topology);
        double totalMemoryRequired = 0.0;
        for (Map.Entry<String, NormalizedResourceRequest> entry : ResourceUtils.getBoltsResources(topology, topoConf).entrySet()) {
            parallelism = componentParallelism.getOrDefault(entry.getKey(), 1);
            memoryRequirement = entry.getValue().getOnHeapMemoryMb();
            totalMemoryRequired += memoryRequirement * (double)parallelism;
        }
        for (Map.Entry<String, NormalizedResourceRequest> entry : ResourceUtils.getSpoutsResources(topology, topoConf).entrySet()) {
            parallelism = componentParallelism.getOrDefault(entry.getKey(), 1);
            memoryRequirement = entry.getValue().getOnHeapMemoryMb();
            totalMemoryRequired += memoryRequirement * (double)parallelism;
        }
        return totalMemoryRequired;
    }

    public static Map<String, Integer> getComponentParallelism(Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Map components = StormCommon.allComponents((StormTopology)topology);
        for (Map.Entry entry : components.entrySet()) {
            ret.put((String)entry.getKey(), ServerUtils.getComponentParallelism(topoConf, entry.getValue()));
        }
        return ret;
    }

    public static int getComponentParallelism(Map<String, Object> topoConf, Object component) throws InvalidTopologyException {
        Map combinedConf = Utils.merge(topoConf, (Map)StormCommon.componentConf((Object)component));
        int numTasks = ObjectReader.getInt(combinedConf.get("topology.tasks"), (Integer)StormCommon.numStartExecutors((Object)component));
        Integer maxParallel = ObjectReader.getInt(combinedConf.get("topology.max.task.parallelism"), null);
        int ret = numTasks;
        if (maxParallel != null) {
            ret = Math.min(maxParallel, numTasks);
        }
        return ret;
    }

    public static Subject principalNameToSubject(String name) {
        SingleUserPrincipal principal = new SingleUserPrincipal(name);
        Subject sub = new Subject();
        sub.getPrincipals().add((Principal)principal);
        return sub;
    }

    public String currentClasspathImpl() {
        return System.getProperty("java.class.path");
    }

    public void downloadResourcesAsSupervisorImpl(String key, String localFile, ClientBlobStore cb) throws AuthorizationException, KeyNotFoundException, IOException {
        int MAX_RETRY_ATTEMPTS = 2;
        int ATTEMPTS_INTERVAL_TIME = 100;
        for (int retryAttempts = 0; retryAttempts < 2 && !ServerUtils.downloadResourcesAsSupervisorAttempt(cb, key, localFile); ++retryAttempts) {
            Utils.sleep((long)100L);
        }
    }
}

