/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.CartridgeAgentEventListeners;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.data.publisher.DataPublisherConfiguration;
import org.apache.stratos.cartridge.agent.data.publisher.exception.DataPublisherException;
import org.apache.stratos.cartridge.agent.data.publisher.log.LogPublisherManager;
import org.apache.stratos.cartridge.agent.event.publisher.CartridgeAgentEventPublisher;
import org.apache.stratos.cartridge.agent.extensions.DefaultExtensionHandler;
import org.apache.stratos.cartridge.agent.extensions.ExtensionHandler;
import org.apache.stratos.cartridge.agent.util.ExtensionUtils;

public class CartridgeAgent
implements Runnable {
    private static final Log log = LogFactory.getLog(CartridgeAgent.class);
    private static final ExtensionHandler extensionHandler = new DefaultExtensionHandler();
    private boolean terminated;
    private CartridgeAgentEventListeners eventListenerns;

    @Override
    public void run() {
        String persistenceMappingsPayload;
        block26: {
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent started");
            }
            this.eventListenerns = new CartridgeAgentEventListeners();
            this.validateRequiredSystemProperties();
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent validated system properties done");
            }
            this.registerTopologyEventListeners();
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent registerTopologyEventListeners done");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Waiting for CompleteTopologyEvent..");
            }
            ExtensionUtils.waitForCompleteTopology();
            if (log.isInfoEnabled()) {
                log.info((Object)"CompleteTopologyEvent received.");
            }
            while (!CartridgeAgentConfiguration.getInstance().isInitialized()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.info((Object)"Waiting for Cartridge Agent to be initialized...");
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {}
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent initialized done");
            }
            this.registerInstanceNotifierEventListeners();
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent registerInstanceNotifierEventListeners done");
            }
            this.registerApplicationEventListeners();
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent registering all event listeners ... done");
            }
            extensionHandler.onInstanceStartedEvent();
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent onInstanceStartedEvent done");
            }
            CartridgeAgentEventPublisher.publishInstanceStartedEvent();
            try {
                extensionHandler.startServerExtension();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block26;
                log.error((Object)"Error processing start servers event", (Throwable)e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent startServerExtension done");
        }
        String repoUrl = CartridgeAgentConfiguration.getInstance().getRepoUrl();
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent getRepoUrl done");
        }
        if ("null".equals(repoUrl) || StringUtils.isBlank((CharSequence)repoUrl)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No artifact repository found. Publishing InstanceActivatedEvent.");
            }
            CartridgeAgentEventPublisher.publishInstanceActivatedEvent();
            extensionHandler.onInstanceActivatedEvent();
            if (log.isInfoEnabled()) {
                log.info((Object)"Cartridge agent onInstanceActivatedEvent done");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Artifact repository found. Waiting for ArtifactUpdatedEvent to commence cloning.");
        }
        if ((persistenceMappingsPayload = CartridgeAgentConfiguration.getInstance().getPersistenceMappings()) != null) {
            extensionHandler.volumeMountExtension(persistenceMappingsPayload);
        }
        LogPublisherManager logPublisherManager = new LogPublisherManager();
        CartridgeAgent.publishLogs(logPublisherManager);
        while (!this.terminated) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {}
        }
        logPublisherManager.stop();
    }

    protected void registerInstanceNotifierEventListeners() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SsubscribeToTopicsAndRegisterListeners before");
        }
        this.eventListenerns.startInstanceNotifierReceiver();
        if (log.isDebugEnabled()) {
            log.debug((Object)"SsubscribeToTopicsAndRegisterListeners after");
        }
    }

    protected void registerTopologyEventListeners() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"registerTopologyEventListeners before");
        }
        this.eventListenerns.startTopologyEventReceiver();
        if (log.isDebugEnabled()) {
            log.debug((Object)"registerTopologyEventListeners after");
        }
    }

    protected void registerTenantEventListeners() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"registerTenantEventListeners before");
        }
        this.eventListenerns.startTenantEventReceiver();
        if (log.isDebugEnabled()) {
            log.debug((Object)"registerTenantEventListeners after");
        }
    }

    protected void registerApplicationEventListeners() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"registerApplicationListeners before");
        }
        this.eventListenerns.startApplicationsEventReceiver();
        if (log.isDebugEnabled()) {
            log.debug((Object)"registerApplicationEventListeners after");
        }
    }

    protected void validateRequiredSystemProperties() {
        String jndiPropertiesDir = System.getProperty("jndi.properties.dir");
        if (StringUtils.isBlank((CharSequence)jndiPropertiesDir)) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("System property not found: %s", "jndi.properties.dir"));
            }
            return;
        }
        String payloadPath = System.getProperty("param.file.path");
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("System property not found: %s", "param.file.path"));
            }
            return;
        }
        String extensionsDir = System.getProperty("extensions.dir");
        if (StringUtils.isBlank((CharSequence)extensionsDir) && log.isWarnEnabled()) {
            log.warn((Object)String.format("System property not found: %s", "extensions.dir"));
        }
    }

    private static void publishLogs(LogPublisherManager logPublisherManager) {
        if (DataPublisherConfiguration.getInstance().isEnabled()) {
            List<String> logFilePaths = CartridgeAgentConfiguration.getInstance().getLogFilePaths();
            if (logFilePaths == null) {
                log.error((Object)"No valid log file paths found, no logs will be published");
            } else {
                try {
                    logPublisherManager.init(DataPublisherConfiguration.getInstance());
                }
                catch (DataPublisherException e) {
                    log.error((Object)"Error occurred in log publisher initialization", (Throwable)e);
                    return;
                }
                for (String logFilePath : logFilePaths) {
                    try {
                        logPublisherManager.start(logFilePath);
                    }
                    catch (DataPublisherException e) {
                        log.error((Object)"Error occurred in publishing logs ", (Throwable)e);
                    }
                }
            }
        }
    }

    public static ExtensionHandler getExtensionHandler() {
        return extensionHandler;
    }

    public void terminate() {
        this.terminated = true;
    }
}

