/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.extensions.DefaultExtensionHandler;
import org.apache.stratos.cartridge.agent.extensions.ExtensionHandler;
import org.apache.stratos.common.threading.StratosThreadPool;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.application.signup.ApplicationSignUpRemovedEvent;
import org.apache.stratos.messaging.event.instance.notifier.ArtifactUpdatedEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupClusterEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupMemberEvent;
import org.apache.stratos.messaging.event.tenant.CompleteTenantEvent;
import org.apache.stratos.messaging.event.tenant.TenantCreatedEvent;
import org.apache.stratos.messaging.event.tenant.TenantRemovedEvent;
import org.apache.stratos.messaging.event.tenant.TenantUpdatedEvent;
import org.apache.stratos.messaging.event.topology.CompleteTopologyEvent;
import org.apache.stratos.messaging.event.topology.MemberActivatedEvent;
import org.apache.stratos.messaging.event.topology.MemberCreatedEvent;
import org.apache.stratos.messaging.event.topology.MemberInitializedEvent;
import org.apache.stratos.messaging.event.topology.MemberStartedEvent;
import org.apache.stratos.messaging.event.topology.MemberSuspendedEvent;
import org.apache.stratos.messaging.event.topology.MemberTerminatedEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.application.signup.ApplicationSignUpRemovedEventListener;
import org.apache.stratos.messaging.listener.instance.notifier.ArtifactUpdateEventListener;
import org.apache.stratos.messaging.listener.instance.notifier.InstanceCleanupClusterEventListener;
import org.apache.stratos.messaging.listener.instance.notifier.InstanceCleanupMemberEventListener;
import org.apache.stratos.messaging.listener.tenant.CompleteTenantEventListener;
import org.apache.stratos.messaging.listener.tenant.TenantCreatedEventListener;
import org.apache.stratos.messaging.listener.tenant.TenantRemovedEventListener;
import org.apache.stratos.messaging.listener.tenant.TenantUpdatedEventListener;
import org.apache.stratos.messaging.listener.topology.CompleteTopologyEventListener;
import org.apache.stratos.messaging.listener.topology.MemberActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberCreatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberInitializedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberStartedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberSuspendedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventReceiver;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventReceiver;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventReceiver;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class CartridgeAgentEventListeners {
    private static final Log log = LogFactory.getLog(CartridgeAgentEventListeners.class);
    private InstanceNotifierEventReceiver instanceNotifierEventReceiver;
    private TopologyEventReceiver topologyEventReceiver;
    private TenantEventReceiver tenantEventReceiver;
    private ApplicationSignUpEventReceiver applicationsEventReceiver;
    private ExtensionHandler extensionHandler;
    private static final ExecutorService eventListenerExecutorService = StratosThreadPool.getExecutorService((String)"cartridge.agent.event.listener.thread.pool", (int)10);

    public CartridgeAgentEventListeners() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating cartridge agent event listeners...");
        }
        this.applicationsEventReceiver = new ApplicationSignUpEventReceiver();
        this.applicationsEventReceiver.setExecutorService(eventListenerExecutorService);
        this.topologyEventReceiver = new TopologyEventReceiver();
        this.topologyEventReceiver.setExecutorService(eventListenerExecutorService);
        this.instanceNotifierEventReceiver = new InstanceNotifierEventReceiver();
        this.tenantEventReceiver = new TenantEventReceiver();
        this.tenantEventReceiver.setExecutorService(eventListenerExecutorService);
        this.extensionHandler = new DefaultExtensionHandler();
        this.addInstanceNotifierEventListeners();
        this.addTopologyEventListeners();
        this.addTenantEventListeners();
        this.addApplicationsEventListeners();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cartridge agent event listeners created");
        }
    }

    public void startTopologyEventReceiver() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting cartridge agent topology event message receiver");
        }
        eventListenerExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                CartridgeAgentEventListeners.this.topologyEventReceiver.execute();
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent topology receiver thread started, waiting for event messages ...");
        }
    }

    public void startInstanceNotifierReceiver() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting cartridge agent instance notifier event message receiver");
        }
        eventListenerExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                CartridgeAgentEventListeners.this.instanceNotifierEventReceiver.execute();
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cartridge agent Instance notifier event message receiver started, waiting for event messages ...");
        }
    }

    public void startTenantEventReceiver() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting cartridge agent tenant event message receiver");
        }
        eventListenerExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                CartridgeAgentEventListeners.this.topologyEventReceiver.execute();
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent tenant receiver thread started, waiting for event messages ...");
        }
    }

    public void startApplicationsEventReceiver() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting cartridge agent application event message receiver");
        }
        eventListenerExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                CartridgeAgentEventListeners.this.applicationsEventReceiver.execute();
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent application receiver thread started, waiting for event messages ...");
        }
    }

    private void addInstanceNotifierEventListeners() {
        this.instanceNotifierEventReceiver.addEventListener((EventListener)new ArtifactUpdateEventListener(){

            protected void onEvent(Event event) {
                block2: {
                    try {
                        CartridgeAgentEventListeners.this.extensionHandler.onArtifactUpdatedEvent((ArtifactUpdatedEvent)event);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block2;
                        log.error((Object)"Error processing artifact update event", (Throwable)e);
                    }
                }
            }
        });
        this.instanceNotifierEventReceiver.addEventListener((EventListener)new InstanceCleanupMemberEventListener(){

            protected void onEvent(Event event) {
                block3: {
                    try {
                        String memberIdInPayload = CartridgeAgentConfiguration.getInstance().getMemberId();
                        InstanceCleanupMemberEvent instanceCleanupMemberEvent = (InstanceCleanupMemberEvent)event;
                        if (memberIdInPayload.equals(instanceCleanupMemberEvent.getMemberId())) {
                            CartridgeAgentEventListeners.this.extensionHandler.onInstanceCleanupMemberEvent(instanceCleanupMemberEvent);
                        }
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block3;
                        log.error((Object)"Error processing instance cleanup member event", (Throwable)e);
                    }
                }
            }
        });
        this.instanceNotifierEventReceiver.addEventListener((EventListener)new InstanceCleanupClusterEventListener(){

            protected void onEvent(Event event) {
                InstanceCleanupClusterEvent instanceCleanupClusterEvent;
                String clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId();
                if (clusterIdInPayload.equals((instanceCleanupClusterEvent = (InstanceCleanupClusterEvent)event).getClusterId())) {
                    CartridgeAgentEventListeners.this.extensionHandler.onInstanceCleanupClusterEvent(instanceCleanupClusterEvent);
                }
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)"Instance notifier event listener added ... ");
        }
    }

    private void addTopologyEventListeners() {
        this.topologyEventReceiver.addEventListener((EventListener)new MemberInitializedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                boolean initialized = CartridgeAgentConfiguration.getInstance().isInitialized();
                if (initialized) {
                    return;
                }
                try {
                    TopologyManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Member initialized event received");
                    }
                    MemberInitializedEvent memberInitializedEvent = (MemberInitializedEvent)event;
                    CartridgeAgentEventListeners.this.extensionHandler.onMemberInitializedEvent(memberInitializedEvent);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing member created event", (Throwable)e);
                    }
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberCreatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                boolean initialized = CartridgeAgentConfiguration.getInstance().isInitialized();
                if (initialized) {
                    return;
                }
                try {
                    TopologyManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Member created event received");
                    }
                    MemberCreatedEvent memberCreatedEvent = (MemberCreatedEvent)event;
                    CartridgeAgentEventListeners.this.extensionHandler.onMemberCreatedEvent(memberCreatedEvent);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing member created event", (Throwable)e);
                    }
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberActivatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                boolean initialized = CartridgeAgentConfiguration.getInstance().isInitialized();
                if (!initialized) {
                    return;
                }
                try {
                    TopologyManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Member activated event received");
                    }
                    MemberActivatedEvent memberActivatedEvent = (MemberActivatedEvent)event;
                    CartridgeAgentEventListeners.this.extensionHandler.onMemberActivatedEvent(memberActivatedEvent);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing member activated event", (Throwable)e);
                    }
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberTerminatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                boolean initialized = CartridgeAgentConfiguration.getInstance().isInitialized();
                if (!initialized) {
                    return;
                }
                try {
                    TopologyManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Member terminated event received");
                    }
                    MemberTerminatedEvent memberTerminatedEvent = (MemberTerminatedEvent)event;
                    CartridgeAgentEventListeners.this.extensionHandler.onMemberTerminatedEvent(memberTerminatedEvent);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing member terminated event", (Throwable)e);
                    }
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberSuspendedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                boolean initialized = CartridgeAgentConfiguration.getInstance().isInitialized();
                if (!initialized) {
                    return;
                }
                try {
                    TopologyManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Member suspended event received");
                    }
                    MemberSuspendedEvent memberSuspendedEvent = (MemberSuspendedEvent)event;
                    CartridgeAgentEventListeners.this.extensionHandler.onMemberSuspendedEvent(memberSuspendedEvent);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing member suspended event", (Throwable)e);
                    }
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new CompleteTopologyEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                boolean initialized = CartridgeAgentConfiguration.getInstance().isInitialized();
                if (!initialized) {
                    try {
                        TopologyManager.acquireReadLock();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Complete topology event received");
                        }
                        CompleteTopologyEvent completeTopologyEvent = (CompleteTopologyEvent)event;
                        CartridgeAgentEventListeners.this.extensionHandler.onCompleteTopologyEvent(completeTopologyEvent);
                    }
                    catch (Exception e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Error processing complete topology event", (Throwable)e);
                        }
                    }
                    finally {
                        TopologyManager.releaseReadLock();
                    }
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberStartedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                boolean initialized = CartridgeAgentConfiguration.getInstance().isInitialized();
                if (!initialized) {
                    return;
                }
                try {
                    TopologyManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Member started event received");
                    }
                    MemberStartedEvent memberStartedEvent = (MemberStartedEvent)event;
                    CartridgeAgentEventListeners.this.extensionHandler.onMemberStartedEvent(memberStartedEvent);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing member started event", (Throwable)e);
                    }
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)"Topology event listener added ... ");
        }
    }

    private void addTenantEventListeners() {
        this.tenantEventReceiver.addEventListener((EventListener)new CompleteTenantEventListener(){
            private boolean initialized;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void onEvent(Event event) {
                if (!this.initialized) {
                    try {
                        TenantManager.acquireReadLock();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Complete tenant event received");
                        }
                        CompleteTenantEvent completeTenantEvent = (CompleteTenantEvent)event;
                        CartridgeAgentEventListeners.this.extensionHandler.onCompleteTenantEvent(completeTenantEvent);
                        this.initialized = true;
                        return;
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) return;
                        log.error((Object)"Error processing complete tenant event", (Throwable)e);
                        return;
                    }
                    finally {
                        TenantManager.releaseReadLock();
                    }
                } else {
                    if (!log.isInfoEnabled()) return;
                    log.info((Object)"Complete tenant event updating task disabled");
                }
            }
        });
        this.tenantEventReceiver.addEventListener((EventListener)new TenantRemovedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                try {
                    TenantManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Tenant removed event received");
                    }
                    TenantRemovedEvent tenantRemovedEvent = (TenantRemovedEvent)event;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tenant removed event received: " + tenantRemovedEvent));
                    }
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing tenant subscribed event", (Throwable)e);
                    }
                }
                finally {
                    TenantManager.releaseReadLock();
                }
            }
        });
        this.tenantEventReceiver.addEventListener((EventListener)new TenantUpdatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                try {
                    TenantManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Tenant updated event received");
                    }
                    TenantUpdatedEvent tenantUpdatedEvent = (TenantUpdatedEvent)event;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tenant updated event received: " + tenantUpdatedEvent));
                    }
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing tenant updated event", (Throwable)e);
                    }
                }
                finally {
                    TenantManager.releaseReadLock();
                }
            }
        });
        this.tenantEventReceiver.addEventListener((EventListener)new TenantCreatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                try {
                    TenantManager.acquireReadLock();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Tenant updated event received");
                    }
                    TenantCreatedEvent tenantCreatedEvent = (TenantCreatedEvent)event;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tenant updated event received: " + tenantCreatedEvent));
                    }
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error processing tenant updated event", (Throwable)e);
                    }
                }
                finally {
                    TenantManager.releaseReadLock();
                }
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)"Tenant event listener added ... ");
        }
    }

    private void addApplicationsEventListeners() {
        this.applicationsEventReceiver.addEventListener((EventListener)new ApplicationSignUpRemovedEventListener(){

            protected void onEvent(Event event) {
                block2: {
                    try {
                        ApplicationSignUpRemovedEvent applicationSignUpRemovedEvent = (ApplicationSignUpRemovedEvent)event;
                        CartridgeAgentEventListeners.this.extensionHandler.onApplicationSignUpRemovedEvent(applicationSignUpRemovedEvent);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block2;
                        log.error((Object)"Error processing ApplicationSignUpRemovedEvent event", (Throwable)e);
                    }
                }
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)"applications event listener added ... ");
        }
    }

    public void terminate() {
        this.topologyEventReceiver.terminate();
    }
}

