/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.impl;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.CartridgeAgent;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.RepositoryInformation;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.internal.CustomJschConfigSessionFactory;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.internal.RepositoryContext;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.util.Utilities;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.extensions.ExtensionHandler;
import org.apache.stratos.cartridge.agent.util.ExtensionUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitBasedArtifactRepository {
    private static final int SUPER_TENANT_ID = -1234;
    private static final Log log = LogFactory.getLog(GitBasedArtifactRepository.class);
    private final ExtensionHandler extensionHandler = CartridgeAgent.getExtensionHandler();
    private static ConcurrentHashMap<Integer, RepositoryContext> tenantToRepoContextMap = new ConcurrentHashMap();
    private static volatile GitBasedArtifactRepository gitBasedArtifactRepository;
    private static String SUPER_TENANT_REPO_PATH;
    private static String TENANT_REPO_PATH;

    private GitBasedArtifactRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GitBasedArtifactRepository getInstance() {
        if (gitBasedArtifactRepository != null) return gitBasedArtifactRepository;
        Class<GitBasedArtifactRepository> clazz = GitBasedArtifactRepository.class;
        synchronized (GitBasedArtifactRepository.class) {
            if (gitBasedArtifactRepository != null) return gitBasedArtifactRepository;
            gitBasedArtifactRepository = new GitBasedArtifactRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gitBasedArtifactRepository;
        }
    }

    private void initGitContext(RepositoryInformation repositoryInformation) {
        log.info((Object)"Initializing git context.");
        int tenantId = Integer.parseInt(repositoryInformation.getTenantId());
        String gitLocalRepoPath = repositoryInformation.getRepoPath();
        RepositoryContext gitRepoCtx = new RepositoryContext();
        String gitRemoteRepoUrl = repositoryInformation.getRepoUrl();
        boolean isMultitenant = repositoryInformation.isMultitenant();
        log.info((Object)("local path " + gitLocalRepoPath));
        log.info((Object)("remote url " + gitRemoteRepoUrl));
        log.info((Object)("tenant " + tenantId));
        gitRepoCtx.setTenantId(tenantId);
        gitRepoCtx.setGitLocalRepoPath(GitBasedArtifactRepository.getRepoPathForTenantId(tenantId, gitLocalRepoPath, isMultitenant));
        gitRepoCtx.setGitRemoteRepoUrl(gitRemoteRepoUrl);
        gitRepoCtx.setRepoUsername(repositoryInformation.getRepoUsername());
        gitRepoCtx.setRepoPassword(repositoryInformation.getRepoPassword());
        try {
            if (this.isKeyBasedAuthentication(gitRemoteRepoUrl, tenantId)) {
                gitRepoCtx.setKeyBasedAuthentication(true);
                this.initSSHAuthentication();
            } else {
                gitRepoCtx.setKeyBasedAuthentication(false);
            }
        }
        catch (Exception e1) {
            log.error((Object)("Exception occurred.. " + e1.getMessage()), (Throwable)e1);
        }
        FileRepository localRepo = null;
        try {
            localRepo = new FileRepository(new File(gitRepoCtx.getGitLocalRepoPath() + "/.git"));
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        gitRepoCtx.setLocalRepo((Repository)localRepo);
        gitRepoCtx.setGit(new Git(localRepo));
        gitRepoCtx.setCloneExists(false);
        this.cacheGitRepoContext(tenantId, gitRepoCtx);
    }

    private static String getRepoPathForTenantId(int tenantId, String gitLocalRepoPath, boolean isMultitenant) {
        StringBuilder repoPathBuilder = new StringBuilder();
        String repoPath = null;
        if (isMultitenant) {
            if (tenantId == -1234) {
                String superTenantRepoPath = CartridgeAgentConfiguration.getInstance().getSuperTenantRepositoryPath();
                if (superTenantRepoPath != null && !superTenantRepoPath.isEmpty()) {
                    superTenantRepoPath = superTenantRepoPath.startsWith("/") ? superTenantRepoPath : "/".concat(superTenantRepoPath);
                    repoPathBuilder.append(gitLocalRepoPath).append(superTenantRepoPath);
                } else {
                    repoPathBuilder.append(gitLocalRepoPath).append(SUPER_TENANT_REPO_PATH);
                }
            } else {
                GitBasedArtifactRepository.createTenantDir(tenantId, gitLocalRepoPath);
                String tenantRepoPath = CartridgeAgentConfiguration.getInstance().getTenantRepositoryPath();
                if (tenantRepoPath != null && !tenantRepoPath.isEmpty()) {
                    tenantRepoPath = tenantRepoPath.startsWith("/") ? tenantRepoPath : "/".concat(tenantRepoPath);
                    tenantRepoPath = tenantRepoPath.endsWith("/") ? tenantRepoPath : tenantRepoPath.concat("/");
                    repoPathBuilder.append(gitLocalRepoPath).append(tenantRepoPath).append(tenantId);
                } else {
                    repoPathBuilder.append(gitLocalRepoPath).append(TENANT_REPO_PATH).append(tenantId);
                }
            }
            repoPath = repoPathBuilder.toString();
        } else {
            repoPath = gitLocalRepoPath;
        }
        log.info((Object)("Repo path returned : " + repoPath));
        return repoPath;
    }

    private static void createTenantDir(int tenantId, String path) {
        String dirPathName = path + TENANT_REPO_PATH + tenantId;
        boolean dirStatus = new File(dirPathName).mkdir();
        if (dirStatus) {
            log.info((Object)("Successfully created directory [" + dirPathName + "] "));
        } else {
            log.error((Object)("Directory creating failed in [" + dirPathName + "] "));
        }
    }

    private boolean isKeyBasedAuthentication(String url, int tenantId) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return false;
        }
        if (url.startsWith("git://github.com")) {
            return false;
        }
        if (url.startsWith("ssh://") || url.contains("@")) {
            return true;
        }
        log.error((Object)("Invalid git URL provided for tenant " + tenantId));
        throw new RuntimeException("Invalid git URL provided for tenant " + tenantId);
    }

    private void initSSHAuthentication() {
        SshSessionFactory.setInstance((SshSessionFactory)new CustomJschConfigSessionFactory());
    }

    private void cacheGitRepoContext(int tenantId, RepositoryContext gitRepoCtx) {
        log.info((Object)"caching repo context");
        tenantToRepoContextMap.put(tenantId, gitRepoCtx);
    }

    private RepositoryContext retrieveCachedGitContext(int tenantId) {
        return tenantToRepoContextMap.get(tenantId);
    }

    private void removeGitRepoContext(int tenantId) {
        tenantToRepoContextMap.remove(tenantId);
    }

    public void commit(RepositoryInformation repoInfo) {
        int tenantId = Integer.parseInt(repoInfo.getTenantId());
        RepositoryContext gitRepoCtx = this.retrieveCachedGitContext(tenantId);
        Git git = gitRepoCtx.getGit();
        StatusCommand statusCmd = git.status();
        Status status = null;
        try {
            status = statusCmd.call();
        }
        catch (GitAPIException e) {
            log.error((Object)("Git status operation for tenant " + gitRepoCtx.getTenantId() + " failed, "), (Throwable)e);
        }
        if (status.isClean()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No changes detected in the local repository for tenant " + tenantId));
            }
            return;
        }
        this.addArtifacts(gitRepoCtx, this.getNewArtifacts(status));
        this.addArtifacts(gitRepoCtx, this.getModifiedArtifacts(status));
        this.removeArtifacts(gitRepoCtx, this.getRemovedArtifacts(status));
        this.commitToLocalRepo(gitRepoCtx);
        this.pushToRemoteRepo(gitRepoCtx);
    }

    private Set<String> getNewArtifacts(Status status) {
        return status.getUntracked();
    }

    private Set<String> getRemovedArtifacts(Status status) {
        return status.getMissing();
    }

    private Set<String> getModifiedArtifacts(Status status) {
        return status.getModified();
    }

    private void addArtifacts(RepositoryContext gitRepoCtx, Set<String> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        AddCommand addCmd = gitRepoCtx.getGit().add();
        Iterator<String> it = artifacts.iterator();
        while (it.hasNext()) {
            addCmd.addFilepattern(it.next());
        }
        try {
            addCmd.call();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added artifacts for tenant : " + gitRepoCtx.getTenantId()));
            }
        }
        catch (GitAPIException e) {
            log.error((Object)("Adding artifact to the local repository at " + gitRepoCtx.getGitLocalRepoPath() + "failed"), (Throwable)e);
            log.error((Object)e);
        }
    }

    private void removeArtifacts(RepositoryContext gitRepoCtx, Set<String> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        RmCommand rmCmd = gitRepoCtx.getGit().rm();
        Iterator<String> it = artifacts.iterator();
        while (it.hasNext()) {
            rmCmd.addFilepattern(it.next());
        }
        try {
            rmCmd.call();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed artifacts for tenant : " + gitRepoCtx.getTenantId()));
            }
        }
        catch (GitAPIException e) {
            log.error((Object)("Removing artifact from the local repository at " + gitRepoCtx.getGitLocalRepoPath() + "failed"), (Throwable)e);
            log.error((Object)e);
        }
    }

    private void commitToLocalRepo(RepositoryContext gitRepoCtx) {
        CommitCommand commitCmd = gitRepoCtx.getGit().commit();
        commitCmd.setMessage("tenant " + gitRepoCtx.getTenantId() + "'s artifacts committed to local repo at " + gitRepoCtx.getGitLocalRepoPath());
        try {
            commitCmd.call();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committed artifacts for tenant : " + gitRepoCtx.getTenantId()));
            }
        }
        catch (GitAPIException e) {
            log.error((Object)("Committing artifacts to local repository failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
        }
    }

    private void pushToRemoteRepo(RepositoryContext gitRepoCtx) {
        UsernamePasswordCredentialsProvider credentialsProvider;
        PushCommand pushCmd = gitRepoCtx.getGit().push();
        if (!gitRepoCtx.getKeyBasedAuthentication() && (credentialsProvider = GitBasedArtifactRepository.createCredentialsProvider(gitRepoCtx)) != null) {
            pushCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        try {
            pushCmd.call();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pushed artifacts for tenant : " + gitRepoCtx.getTenantId()));
            }
        }
        catch (GitAPIException e) {
            log.error((Object)("Pushing artifacts to remote repository failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
        }
    }

    public boolean checkout(RepositoryInformation repositoryInformation) throws Exception {
        RepositoryContext gitRepoCtx;
        File gitRepoDir;
        int tenantId = Integer.parseInt(repositoryInformation.getTenantId());
        if (tenantToRepoContextMap.get(tenantId) == null) {
            this.initGitContext(repositoryInformation);
        }
        if (!(gitRepoDir = new File((gitRepoCtx = this.retrieveCachedGitContext(tenantId)).getGitLocalRepoPath())).exists()) {
            return this.cloneRepository(gitRepoCtx);
        }
        if (GitBasedArtifactRepository.isValidGitRepo(gitRepoCtx)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Existing git repository detected for tenant " + gitRepoCtx.getTenantId() + ", no clone required"));
            }
            return this.pullAndHandleErrors(gitRepoCtx);
        }
        if (gitRepoDir.list().length > 0) {
            if (this.syncInitialLocalArtifacts(gitRepoCtx)) {
                log.info((Object)("Existing local artifacts for tenant [" + gitRepoCtx.getTenantId() + "] synchronized with remote repository successfully"));
                return this.pullAndHandleErrors(gitRepoCtx);
            }
            return false;
        }
        return this.cloneRepository(gitRepoCtx);
    }

    public boolean removeRepo(int tenantId) throws IOException {
        RepositoryContext gitRepoCtx = this.retrieveCachedGitContext(tenantId);
        log.info((Object)("git repository deleted for tenant " + gitRepoCtx.getTenantId()));
        gitRepoCtx.getArtifactSyncSchedular().shutdown();
        FileUtils.deleteDirectory((File)gitRepoCtx.getLocalRepo().getDirectory());
        FileUtils.deleteDirectory((File)new File(gitRepoCtx.getGitLocalRepoPath()));
        this.removeGitRepoContext(tenantId);
        if (tenantId == -1234 && CartridgeAgentConfiguration.getInstance().isMultitenant()) {
            ExtensionUtils.executeCopyArtifactsExtension("/tmp/-1234/", CartridgeAgentConfiguration.getInstance().getAppPath() + "/repository/deployment/server/");
        }
        return true;
    }

    private boolean pullAndHandleErrors(RepositoryContext gitRepoCtx) {
        try {
            return this.pullArtifacts(gitRepoCtx);
        }
        catch (CheckoutConflictException e) {
            return this.checkoutFromRemoteHead(gitRepoCtx, e.getConflictingPaths());
        }
    }

    private boolean checkoutFromRemoteHead(RepositoryContext gitRepoCtx, List<String> paths) {
        boolean checkoutSuccess = false;
        CheckoutCommand checkoutCmd = gitRepoCtx.getGit().checkout();
        for (String path : paths) {
            checkoutCmd.addPath(path);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added the file path " + path + " to checkout from the remote repository"));
        }
        checkoutCmd.setStartPoint("remotes/origin/master");
        try {
            checkoutCmd.call();
            checkoutSuccess = true;
            log.info((Object)"Checked out the conflicting files from the remote repository successfully");
        }
        catch (GitAPIException e) {
            log.error((Object)"Checking out artifacts from index failed", (Throwable)e);
        }
        return checkoutSuccess;
    }

    private void resetToRemoteHead(RepositoryContext gitRepoCtx, List<String> paths) {
        ResetCommand resetCmd = gitRepoCtx.getGit().reset();
        resetCmd.setMode(ResetCommand.ResetType.HARD).setRef("origin/master");
        for (String path : paths) {
            resetCmd.addPath(path);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added the file path " + path + " to reset"));
        }
        try {
            resetCmd.call();
            log.info((Object)"Reset the local branch to origin master successfully");
        }
        catch (GitAPIException e) {
            log.error((Object)"Reset to origin master failed", (Throwable)e);
        }
    }

    private boolean syncInitialLocalArtifacts(RepositoryContext gitRepoCtx) throws Exception {
        GitBasedArtifactRepository.InitGitRepository(new File(gitRepoCtx.getGitLocalRepoPath()));
        boolean syncedLocalArtifacts = GitBasedArtifactRepository.addRemote(gitRepoCtx.getLocalRepo(), gitRepoCtx.getGitRemoteRepoUrl());
        return syncedLocalArtifacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSyncTask(RepositoryInformation repoInformation, boolean autoCheckout, boolean autoCommit, long delay) {
        int tenantId = Integer.parseInt(repoInformation.getTenantId());
        RepositoryContext repoCtxt = tenantToRepoContextMap.get(tenantId);
        if (repoCtxt == null) {
            log.error((Object)("Unable to schedule artifact sync task, repositoryContext null for tenant " + tenantId));
            return;
        }
        if (repoCtxt.getArtifactSyncSchedular() == null) {
            RepositoryContext repositoryContext = repoCtxt;
            synchronized (repositoryContext) {
                if (repoCtxt.getArtifactSyncSchedular() == null) {
                    ScheduledExecutorService artifactSyncScheduler = Executors.newScheduledThreadPool(1, new ArtifactSyncTaskThreadFactory(repoCtxt.getGitLocalRepoPath()));
                    artifactSyncScheduler.scheduleAtFixedRate(new ArtifactSyncTask(repoInformation, autoCheckout, autoCommit), delay, delay, TimeUnit.SECONDS);
                    repoCtxt.setArtifactSyncSchedular(artifactSyncScheduler);
                    log.info((Object)("Scheduled Artifact Synchronization Task for path " + repoCtxt.getGitLocalRepoPath()));
                } else {
                    log.info((Object)("Artifact Synchronization Task for path " + repoCtxt.getGitLocalRepoPath() + " already scheduled"));
                }
            }
        }
    }

    public boolean cloneExists(RepositoryInformation repositoryInformation) {
        RepositoryContext gitRepoCtx;
        int tenantId = Integer.parseInt(repositoryInformation.getTenantId());
        if (tenantToRepoContextMap.get(tenantId) == null) {
            this.initGitContext(repositoryInformation);
        }
        if ((gitRepoCtx = this.retrieveCachedGitContext(tenantId)) == null) {
            return false;
        }
        return gitRepoCtx.cloneExists();
    }

    private boolean pullArtifacts(RepositoryContext gitRepoCtx) throws CheckoutConflictException {
        PullCommand pullCmd = gitRepoCtx.getGit().pull();
        UsernamePasswordCredentialsProvider credentialsProvider = GitBasedArtifactRepository.createCredentialsProvider(gitRepoCtx);
        if (credentialsProvider == null) {
            log.warn((Object)("Remote repository credentials not available for tenant " + gitRepoCtx.getTenantId() + ", aborting pull"));
            return false;
        }
        pullCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        try {
            PullResult pullResult = pullCmd.call();
            if (!pullResult.getFetchResult().getTrackingRefUpdates().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Artifacts were updated as a result of the pull operation, thread: " + Thread.currentThread().getName() + " - " + Thread.currentThread().getId()));
                }
                this.extensionHandler.onArtifactUpdateSchedulerEvent(String.valueOf(gitRepoCtx.getTenantId()));
            }
        }
        catch (InvalidConfigurationException e) {
            log.warn((Object)("Git pull unsuccessful for tenant " + gitRepoCtx.getTenantId() + ", invalid configuration. " + e.getMessage()));
            Utilities.deleteFolderStructure(new File(gitRepoCtx.getGitLocalRepoPath()));
            this.cloneRepository(gitRepoCtx);
            this.extensionHandler.onArtifactUpdateSchedulerEvent(String.valueOf(gitRepoCtx.getTenantId()));
            return true;
        }
        catch (JGitInternalException e) {
            log.warn((Object)("Git pull unsuccessful for tenant " + gitRepoCtx.getTenantId() + ", " + e.getMessage()));
            return false;
        }
        catch (TransportException e) {
            log.error((Object)("Accessing remote git repository " + gitRepoCtx.getGitRemoteRepoUrl() + " failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
            return false;
        }
        catch (CheckoutConflictException e) {
            log.warn((Object)("Git pull unsuccessful for tenant " + gitRepoCtx.getTenantId() + ", conflicts detected"));
            throw e;
        }
        catch (GitAPIException e) {
            log.error((Object)("Git pull operation for tenant " + gitRepoCtx.getTenantId() + " failed"), (Throwable)e);
            return false;
        }
        return true;
    }

    private void handleInvalidConfigurationError(RepositoryContext gitRepoCtx) {
        StoredConfig storedConfig = gitRepoCtx.getLocalRepo().getConfig();
        boolean modifiedConfig = false;
        if (storedConfig != null) {
            if (storedConfig.getString("branch", "master", "remote") == null || storedConfig.getString("branch", "master", "remote").isEmpty()) {
                storedConfig.setString("branch", "master", "remote", "origin");
                modifiedConfig = true;
            }
            if (storedConfig.getString("branch", "master", "merge") == null || storedConfig.getString("branch", "master", "merge").isEmpty()) {
                storedConfig.setString("branch", "master", "merge", "refs/heads/master");
                modifiedConfig = true;
            }
            if (modifiedConfig) {
                try {
                    storedConfig.save();
                }
                catch (IOException e) {
                    String message = "Error saving git configuration file in local repo at " + gitRepoCtx.getGitLocalRepoPath();
                    System.out.println(message);
                    log.error((Object)message, (Throwable)e);
                }
            }
        }
    }

    private boolean cloneRepository(RepositoryContext gitRepoCtx) {
        boolean cloneSuccess = false;
        File gitRepoDir = new File(gitRepoCtx.getGitLocalRepoPath());
        CloneCommand cloneCmd = Git.cloneRepository().setURI(gitRepoCtx.getGitRemoteRepoUrl()).setDirectory(gitRepoDir).setBranch("refs/heads/master");
        UsernamePasswordCredentialsProvider credentialsProvider = GitBasedArtifactRepository.createCredentialsProvider(gitRepoCtx);
        if (credentialsProvider == null) {
            log.warn((Object)("Remote repository credentials not available for tenant " + gitRepoCtx.getTenantId() + ", aborting clone"));
            return false;
        }
        cloneCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        try {
            cloneCmd.call();
            log.info((Object)("Git clone operation for tenant " + gitRepoCtx.getTenantId() + " successful"));
            gitRepoCtx.setCloneExists(true);
            cloneSuccess = true;
        }
        catch (TransportException e) {
            log.error((Object)("Accessing remote git repository failed for tenant " + gitRepoCtx.getTenantId()), (Throwable)e);
        }
        catch (GitAPIException e) {
            log.error((Object)("Git clone operation for tenant " + gitRepoCtx.getTenantId() + " failed"), (Throwable)e);
        }
        return cloneSuccess;
    }

    private static UsernamePasswordCredentialsProvider createCredentialsProvider(RepositoryContext gitRepoCtx) {
        return new UsernamePasswordCredentialsProvider(gitRepoCtx.getRepoUsername(), gitRepoCtx.getRepoPassword());
    }

    private static boolean isValidGitRepo(RepositoryContext gitRepoCtx) {
        if (gitRepoCtx.cloneExists()) {
            return true;
        }
        for (Ref ref : gitRepoCtx.getLocalRepo().getAllRefs().values()) {
            if (ref.getObjectId() == null) continue;
            return true;
        }
        return false;
    }

    public static void InitGitRepository(File gitRepoDir) throws Exception {
        try {
            Git.init().setDirectory(gitRepoDir).setBare(false).call();
        }
        catch (GitAPIException e) {
            String errorMsg = "Initializing local repo at " + gitRepoDir.getPath() + " failed";
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
    }

    public static boolean addRemote(Repository repository, String remoteUrl) {
        boolean remoteAdded = false;
        StoredConfig config = repository.getConfig();
        config.setString("remote", "origin", "url", remoteUrl);
        config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
        config.setString("branch", "master", "remote", "origin");
        config.setString("branch", "master", "merge", "refs/heads/master");
        try {
            config.save();
            remoteAdded = true;
        }
        catch (IOException e) {
            log.error((Object)("Error in adding remote origin " + remoteUrl + " for local repository " + repository.toString()), (Throwable)e);
        }
        return remoteAdded;
    }

    public void cleanupAutoCheckout() {
    }

    public String getRepositoryType() {
        return null;
    }

    static {
        SUPER_TENANT_REPO_PATH = "/repository/deployment/server/";
        TENANT_REPO_PATH = "/repository/tenants/";
    }

    class ArtifactSyncTaskThreadFactory
    implements ThreadFactory {
        private String localRepoPath;

        public ArtifactSyncTaskThreadFactory(String localRepoPath) {
            this.localRepoPath = localRepoPath;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Artifact Update Thread - " + this.localRepoPath);
        }
    }

    private class ArtifactSyncTask
    implements Runnable {
        private RepositoryInformation repositoryInformation;
        private boolean autoCheckout;
        private boolean autoCommit;

        public ArtifactSyncTask(RepositoryInformation repositoryInformation, boolean autoCheckout, boolean autoCommit) {
            this.repositoryInformation = repositoryInformation;
            this.autoCheckout = autoCheckout;
            this.autoCommit = autoCommit;
        }

        @Override
        public void run() {
            try {
                if (this.autoCheckout) {
                    GitBasedArtifactRepository.this.checkout(this.repositoryInformation);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (this.autoCommit) {
                GitBasedArtifactRepository.this.commit(this.repositoryInformation);
            }
        }
    }
}

