/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.config;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.exception.ParameterNotFoundException;
import org.apache.stratos.cartridge.agent.util.CartridgeAgentUtils;

public class CartridgeAgentConfiguration {
    private static final Log log = LogFactory.getLog(CartridgeAgentConfiguration.class);
    private static volatile CartridgeAgentConfiguration instance;
    private boolean initialized;
    private final String serviceGroup;
    private final String serviceName;
    private final String clusterId;
    private final String networkPartitionId;
    private final String partitionId;
    private final String memberId;
    private final String cartridgeKey;
    private final String appPath;
    private final String repoUrl;
    private final List<Integer> ports;
    private final List<String> logFilePaths;
    private final boolean isCommitsEnabled;
    private final boolean isCheckoutEnabled;
    private final String listenAddress;
    private final String lbClusterId;
    private final String tenantId;
    private final String isClustered;
    private final String minCount;
    private Map<String, String> parameters = this.loadParametersFile();
    private boolean isMultitenant;
    private String persistenceMappings;
    private boolean isInternalRepo;
    private String isPrimary;
    private String lbPrivateIp;
    private String lbPublicIp;
    private String deployment;
    private String managerServiceName;
    private String workerServiceName;
    private String superTenantRepositoryPath;
    private String tenantRepositoryPath;
    private String kubernetesClusterId;
    private String instanceId;
    private String clusterInstanceId;
    private String applicationId;
    private String dependantClusterId;

    private CartridgeAgentConfiguration() {
        try {
            this.applicationId = this.readApplicationId();
            this.serviceGroup = this.readServiceGroup();
            this.isClustered = this.readClustering();
            this.serviceName = this.readParameterValue("SERVICE_NAME");
            this.clusterId = this.readParameterValue("CLUSTER_ID");
            this.networkPartitionId = this.readParameterValue("NETWORK_PARTITION_ID");
            this.partitionId = this.readParameterValue("PARTITION_ID");
            this.memberId = this.readMemberIdValue("MEMBER_ID");
            this.cartridgeKey = this.readParameterValue("CARTRIDGE_KEY");
            this.appPath = this.readParameterValue("APPLICATION_PATH");
            this.repoUrl = this.readParameterValue("REPO_URL");
            this.ports = this.readPorts();
            this.logFilePaths = this.readLogFilePaths();
            this.isMultitenant = this.readMultitenant("MULTITENANT");
            this.persistenceMappings = this.readPersistenceMapping();
            this.isCommitsEnabled = this.readCommitParameterValue();
            this.isCheckoutEnabled = Boolean.parseBoolean(System.getProperty("auto.checkout"));
            this.listenAddress = System.getProperty("listen.address");
            this.isInternalRepo = this.readInternalRepo("PROVIDER");
            this.tenantId = this.readParameterValue("TENANT_ID");
            this.lbClusterId = this.readLBClusterIdValue("LB_CLUSTER_ID");
            this.minCount = this.readMinCountValue("MIN_COUNT");
            this.lbPrivateIp = System.getProperty("lb.private.ip");
            this.lbPublicIp = System.getProperty("lb.public.ip");
            this.tenantRepositoryPath = System.getProperty("tenant.repository.path");
            this.superTenantRepositoryPath = System.getProperty("super.tenant.repository.path");
            this.deployment = this.readDeployment();
            this.managerServiceName = this.readManagerServiceType();
            this.workerServiceName = this.readWorkerServiceType();
            this.isPrimary = this.readIsPrimary();
            this.kubernetesClusterId = this.readKubernetesClusterIdValue("KUBERNETES_CLUSTER_ID");
            this.clusterInstanceId = this.readClusterInstanceId();
            this.dependantClusterId = this.readDependantClusterId();
        }
        catch (ParameterNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent configuration initialized");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("application-id: %s", this.applicationId));
            log.debug((Object)String.format("service-group: %s", this.serviceGroup));
            log.debug((Object)String.format("cluster-id: %s", this.clusterId));
            log.debug((Object)String.format("service-name: %s", this.serviceName));
            log.debug((Object)String.format("cluster-id: %s", this.clusterId));
            log.debug((Object)String.format("network-partition-id: %s", this.networkPartitionId));
            log.debug((Object)String.format("partition-id: %s", this.partitionId));
            log.debug((Object)String.format("member-id: %s", this.memberId));
            log.debug((Object)String.format("cartridge-key: %s", this.cartridgeKey));
            log.debug((Object)String.format("app-path: %s", this.appPath));
            log.debug((Object)String.format("repo-url: %s", this.repoUrl));
            log.debug((Object)String.format("ports: %s", this.ports.toString()));
            log.debug((Object)String.format("lb-private-ip: %s", this.lbPrivateIp));
            log.debug((Object)String.format("lb-public-ip: %s", this.lbPublicIp));
            log.debug((Object)String.format("cluster-instance-id: %s", this.clusterInstanceId));
            log.debug((Object)String.format("dependant-cluster-id: %s", this.dependantClusterId));
        }
    }

    private String readKubernetesClusterIdValue(String kubernetesClusterId) {
        String kubernetesClusterIdValue = null;
        if (this.parameters.containsKey(kubernetesClusterId)) {
            kubernetesClusterIdValue = this.parameters.get(kubernetesClusterId);
        }
        if (System.getProperty(kubernetesClusterId) != null) {
            kubernetesClusterIdValue = System.getProperty(kubernetesClusterId);
        }
        return kubernetesClusterIdValue;
    }

    private String readMemberIdValue(String memberId) {
        String memberIdValue = null;
        if (this.parameters.containsKey(memberId) && this.parameters.get(memberId) != null) {
            memberIdValue = this.parameters.get(memberId);
        } else if (System.getProperty(memberId) != null) {
            memberIdValue = System.getProperty(memberId);
        } else {
            String hostname = "unknown";
            try {
                log.info((Object)"Reading hostname from container");
                InetAddress addr = InetAddress.getLocalHost();
                hostname = addr.getHostName();
            }
            catch (UnknownHostException e) {
                String msg = "Hostname can not be resolved";
                log.error((Object)msg, (Throwable)e);
            }
            memberIdValue = hostname;
            if (log.isDebugEnabled()) {
                log.debug((Object)("MemberId  is taking the value of hostname : [" + memberIdValue + "] "));
            }
        }
        return memberIdValue;
    }

    private String readDeployment() {
        if (this.parameters.containsKey("DEPLOYMENT")) {
            return this.parameters.get("DEPLOYMENT");
        }
        return null;
    }

    private String readLBClusterIdValue(String lbClusterId) {
        String lbClusterIdValue = null;
        if (this.parameters.containsKey(lbClusterId)) {
            lbClusterIdValue = this.parameters.get(lbClusterId);
        }
        if (System.getProperty(lbClusterId) != null) {
            lbClusterIdValue = System.getProperty(lbClusterId);
        }
        return lbClusterIdValue;
    }

    private String readMinCountValue(String minCountParam) throws ParameterNotFoundException {
        String minCountValue = null;
        if (this.parameters.containsKey(minCountParam)) {
            minCountValue = this.parameters.get(minCountParam);
        }
        if (System.getProperty(minCountParam) != null) {
            minCountValue = System.getProperty(minCountParam);
        }
        if (Boolean.parseBoolean(this.isClustered)) {
            String message = "Cannot find the value of required parameter: " + minCountParam;
            throw new ParameterNotFoundException(message);
        }
        return minCountValue;
    }

    private String readManagerServiceType() {
        if (this.deployment == null) {
            return null;
        }
        if (this.getDeployment().equalsIgnoreCase("manager")) {
            return this.serviceName;
        }
        if (this.getDeployment().equalsIgnoreCase("worker")) {
            if (this.parameters.containsKey("MANAGER_SERVICE_TYPE")) {
                return this.parameters.get("MANAGER_SERVICE_TYPE");
            }
        } else if (this.getDeployment().equalsIgnoreCase("default")) {
            return null;
        }
        return null;
    }

    private String readWorkerServiceType() {
        if (this.deployment == null) {
            return null;
        }
        if (this.getDeployment().equalsIgnoreCase("worker")) {
            return this.serviceName;
        }
        if (this.getDeployment().equalsIgnoreCase("manager")) {
            if (this.parameters.containsKey("WORKER_SERVICE_TYPE")) {
                return this.parameters.get("WORKER_SERVICE_TYPE");
            }
        } else if (this.getDeployment().equalsIgnoreCase("default")) {
            return null;
        }
        return null;
    }

    private String readIsPrimary() {
        if (this.parameters.containsKey("PRIMARY")) {
            return this.parameters.get("PRIMARY");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CartridgeAgentConfiguration getInstance() {
        if (instance != null) return instance;
        Class<CartridgeAgentConfiguration> clazz = CartridgeAgentConfiguration.class;
        synchronized (CartridgeAgentConfiguration.class) {
            if (instance != null) return instance;
            instance = new CartridgeAgentConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean readCommitsEnabled(String commitEnabled) {
        boolean isCommitEnabled = false;
        try {
            isCommitEnabled = Boolean.parseBoolean(this.readParameterValue(commitEnabled));
        }
        catch (ParameterNotFoundException e) {
            log.error((Object)" Commits enabled payload parameter is not found");
        }
        return isCommitEnabled;
    }

    private boolean readMultitenant(String multitenant) throws ParameterNotFoundException {
        String multitenantStringValue = this.readParameterValue(multitenant);
        return Boolean.parseBoolean(multitenantStringValue);
    }

    private boolean readInternalRepo(String internalRepo) {
        String internalRepoStringValue = null;
        try {
            internalRepoStringValue = this.readParameterValue(internalRepo);
        }
        catch (ParameterNotFoundException e) {
            log.info((Object)" INTERNAL payload parameter is not found");
        }
        return internalRepoStringValue != null && internalRepoStringValue.equals("internal");
    }

    private String readPersistenceMapping() {
        String persistenceMapping;
        block3: {
            persistenceMapping = null;
            try {
                persistenceMapping = this.readParameterValue("PERSISTENCE_MAPPING");
            }
            catch (ParameterNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Cannot read persistence mapping : " + e.getMessage()));
            }
        }
        if (persistenceMapping == null || persistenceMapping.isEmpty()) {
            return null;
        }
        return persistenceMapping;
    }

    private Map<String, String> loadParametersFile() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            File file = new File(System.getProperty("param.file.path"));
            if (!file.exists()) {
                log.warn((Object)String.format("File not found: %s", "param.file.path"));
                return parameters;
            }
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String[] params;
                String line = scanner.nextLine();
                for (String string : params = line.split(",")) {
                    String[] var;
                    if (string == null || (var = string.split("=")).length < 2) continue;
                    parameters.put(var[0], var[1]);
                }
            }
            scanner.close();
        }
        catch (Exception e) {
            String message = "Could not read launch parameter file, hence trying to read from System properties.";
            log.warn((Object)message, (Throwable)e);
        }
        return parameters;
    }

    private String readApplicationId() {
        if (this.parameters.containsKey("APPLICATION_ID")) {
            return this.parameters.get("APPLICATION_ID");
        }
        return null;
    }

    private String readServiceGroup() {
        if (this.parameters.containsKey("SERIVCE_GROUP")) {
            return this.parameters.get("SERIVCE_GROUP");
        }
        return null;
    }

    private String readClusterInstanceId() {
        if (this.parameters.containsKey("CLUSTER_INSTANCE_ID")) {
            return this.parameters.get("CLUSTER_INSTANCE_ID");
        }
        return null;
    }

    private String readDependantClusterId() {
        if (this.parameters.containsKey("DEPENDENCY_CLUSTER_IDS")) {
            return this.parameters.get("DEPENDENCY_CLUSTER_IDS");
        }
        return null;
    }

    private String readClustering() {
        if (this.parameters.containsKey("CLUSTERING")) {
            return this.parameters.get("CLUSTERING");
        }
        return null;
    }

    private String readParameterValue(String parameterName) throws ParameterNotFoundException {
        if (this.parameters.containsKey(parameterName)) {
            return this.parameters.get(parameterName);
        }
        if (System.getProperty(parameterName) != null) {
            return System.getProperty(parameterName);
        }
        String message = "Cannot find the value of required parameter: " + parameterName;
        throw new ParameterNotFoundException(message);
    }

    private boolean readCommitParameterValue() throws ParameterNotFoundException {
        if (this.parameters.containsKey("COMMIT_ENABLED")) {
            return Boolean.parseBoolean(this.parameters.get("COMMIT_ENABLED"));
        }
        if (System.getProperty("COMMIT_ENABLED") != null) {
            return Boolean.parseBoolean(System.getProperty("COMMIT_ENABLED"));
        }
        if (System.getProperty("auto.commit") != null) {
            return Boolean.parseBoolean(System.getProperty("auto.commit"));
        }
        log.info((Object)"COMMIT_ENABLED is not found and setting it to false");
        return false;
    }

    private List<Integer> readPorts() throws ParameterNotFoundException {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        String portsStr = this.readParameterValue("PORTS");
        List<String> portsStrList = CartridgeAgentUtils.splitUsingTokenizer(portsStr, "|");
        for (String port : portsStrList) {
            ports.add(Integer.parseInt(port));
        }
        return ports;
    }

    private List<String> readLogFilePaths() {
        String logFileStr;
        block3: {
            logFileStr = null;
            try {
                logFileStr = this.readParameterValue("LOG_FILE_PATHS");
            }
            catch (ParameterNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Cannot read log file path : " + e.getMessage()));
            }
        }
        if (logFileStr == null || logFileStr.isEmpty()) {
            return null;
        }
        return CartridgeAgentUtils.splitUsingTokenizer(logFileStr.trim(), "|");
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getNetworkPartitionId() {
        return this.networkPartitionId;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getCartridgeKey() {
        return this.cartridgeKey;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<String> getLogFilePaths() {
        return this.logFilePaths;
    }

    public boolean isMultitenant() {
        return this.isMultitenant;
    }

    public String getPersistenceMappings() {
        return this.persistenceMappings;
    }

    public boolean isCommitsEnabled() {
        return this.isCommitsEnabled;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public boolean isInternalRepo() {
        return this.isInternalRepo;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getLbClusterId() {
        return this.lbClusterId;
    }

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public String getIsClustered() {
        return this.isClustered;
    }

    public String getMinCount() {
        return this.minCount;
    }

    public String getIsPrimary() {
        return this.isPrimary;
    }

    public String getLbPublicIp() {
        return this.lbPublicIp;
    }

    public void setLbPublicIp(String lbPublicIp) {
        this.lbPublicIp = lbPublicIp;
    }

    public String getLbPrivateIp() {
        return this.lbPrivateIp;
    }

    public void setLbPrivateIp(String lbPrivateIp) {
        this.lbPrivateIp = lbPrivateIp;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public void setDeployment(String deployment) {
        this.deployment = deployment;
    }

    public String getManagerServiceName() {
        return this.managerServiceName;
    }

    public void setManagerServiceName(String managerServiceName) {
        this.managerServiceName = managerServiceName;
    }

    public String getWorkerServiceName() {
        return this.workerServiceName;
    }

    public void setWorkerServiceName(String workerServiceName) {
        this.workerServiceName = workerServiceName;
    }

    public String getSuperTenantRepositoryPath() {
        return this.superTenantRepositoryPath;
    }

    public String getTenantRepositoryPath() {
        return this.tenantRepositoryPath;
    }

    public boolean isCheckoutEnabled() {
        return this.isCheckoutEnabled;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getKubernetesClusterId() {
        return this.kubernetesClusterId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getClusterInstanceId() {
        return this.clusterInstanceId;
    }

    public void setClusterInstanceId(String clusterInstanceId) {
        this.clusterInstanceId = clusterInstanceId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }
}

